require('dotenv').config({ path: '/etc/direct-tokens/twilight/.env' });

const path = require('path');

module.exports = function(config) {

    config.tanker.project = 'direct2';
    config.tanker.token = process.env.TWILIGHT_TANKER_TOKEN;
    config.tanker.force = true;

    if (process.env.TANKER_BRANCH) {
        config.tanker.branch = process.env.TANKER_BRANCH;
    } else {
        throw new Error('Не задана переменная TANKER_BRANCH')
    }

    let levels = ['desktop.blocks', 'common.blocks', 'node_modules/bricks/source.blocks', 'touch.blocks'];
    // команды для поиска файлов в которых нужно искать ключи для переводов
    config.finders = [
        `find ${levels.map(level => `${level}`).join(' ')} -name \\*\\.js`
    ];

    config.dispatchers.json = path.join(__dirname, 'dispatcher.js');
    config.parsers = ['js', 'vm.js', 'utils.js', 'bemhtml.js', 'bemtree.js'].reduce((acc, key) => {
        acc[key] = path.join(__dirname, 'parser.js');

        return acc;
    }, {});

    // отключаем проверку поля keyset
    config.resolving.neverTrust = [];
};
