/**
 * @see https://github.yandex-team.ru/lego/tanker-kit/blob/dev/ext/dispatchers/json2bem.js
 */
var path   = require('path'),
    fs     = require('fs'),
    assert = require('assert'),
    _      = require('lodash'),
    keys   = Object.keys,
    tmpl   = _.template('module.exports = ${ data };\n'),
    tanker = require('tanker-kit'),
    saferequire = tanker.util.saferequire,
    isBricksKeyset = keyset => /^bricks:/.test(keyset),
    isCommanderOrDnaKeyset = keyset => /^commander:|^dna:/.test(keyset);

module.exports = function(arg) {
    // для отладки
    if (arg) {
        fs.writeFileSync(path.join(process.env.HOME, 'tanker-pull-data'), JSON.stringify(arg));
    } else {
        arg = JSON.parse(fs.readFileSync(path.join(process.env.HOME, 'tanker-pull-data'), 'utf8'));
    }

    var mapJSON = saferequire(arg.info.config.paths.tankerMap);

    if (!mapJSON) {
        console.error('Отсутствует файл .tanker/map.json. Выполните tanker push.');
        return {};
    }

    var json   = JSON.parse(arg.data),
        langs  = Object.keys(json),
        result = {},
        mapResult = {};

    // TODO: понять что это такое
    // считаем, что ключи, которые уже есть в танкере больше загружать не надо, а все остальные - надо
    // существующие измененные ключи найдутся парсером и им выставится upload: true
    // Object.keys(mapJSON).forEach(function(hash) {
    //     mapJSON[hash].forEach(function(item) {
    //         try {
    //             item.upload = !(item.key in json.ru[item.keyset]);
    //         } catch (e) {
    //             // do nothing
    //         }
    //     });
    // });
    // fs.writeFileSync(arg.info.config.paths.tankerMap, JSON.stringify(mapJSON, null, 4));
    // console.log('ОБновлен статус upload в map.json');
    // TODO: понять что это такое

    // Делает объект с путями к файлам
    // чтобы потом было удобно понять в какой технологии используется ключ
    // { keyset:
    //     { key1: [path1, path2] },
    //     { key2: [path1, path2] },
    //     { key3: [path1, path2] },
    //     { key4: [path1, path2] }
    // }
    Object.keys(mapJSON).forEach(key => {
        var array = mapJSON[key];

        array.forEach(strData => {
            let keysetData = mapResult[strData.keyset] || (mapResult[strData.keyset] = {});
            let strData2 = keysetData[strData.key] || (keysetData[strData.key] = {});

            strData2[strData.path] = true;
        });
    });

    langs.forEach(function(lang) {
        var keysets = Object.keys(json[lang]);

        keysets
            .filter(function(keyset) {
                // игнорируем кейсеты commander|dna:...
                return !isCommanderOrDnaKeyset(keyset);
            })
            .forEach(function(keyset) {
                var translationsData = {},

                    allKeys = json[lang][keyset],
                    isBricks = isBricksKeyset(keyset),
                    bemKeyset = isBricks ? keyset.replace(/^bricks:/, '') : keyset,
                    keysetPath;

                Object.keys(allKeys).forEach(function(key) {

                    if (mapResult[keyset] && mapResult[keyset][key]) {
                        var allPaths = Object.keys(mapResult[keyset][key]),
                            levelPath = 'desktop.blocks';

                        allPaths.forEach(function(filePath) {
                            var fileTech = path.basename(filePath).split('.').slice(1).join('.');

                            translationsData[bemKeyset] || (translationsData[bemKeyset] = {});
                            translationsData[bemKeyset][key] || (translationsData[bemKeyset][key] = json[lang][keyset][key]);

                            levelPath = filePath.split('/')[0];
                        });

                        keysetPath = getPathByKeyset({
                            keyset: bemKeyset,
                            path: [levelPath, bemKeyset].join('/'),
                            isBricks: isBricks,
                            lang: lang
                        });
                    }
                });

                if (keysetPath) {
                    result[keysetPath] = tmpl({ data: JSON.stringify(translationsData, null, 4) });
                }
        });
    });

    return result;
};

/**
 * Возвращает пути к переводам
 * @param data.keyset
 * @param data.path
 * @param data.lang
 * @param data.isBricks
 * @returns {String}
 */
function getPathByKeyset(data) {
    var pathDir = data.isBricks ? path.join('bricks.translations', data.keyset) : data.path;

    return path.join(pathDir, data.keyset + '.i18n', data.lang + '.js');
}
