/**
 * @see https://github.yandex-team.ru/lego/tanker-kit/tree/dev/ext/parsers
 */
var _             = require('lodash'),
    esprima       = require('esprima'),
    util          = require('tanker-kit/ext/lib/util'),
    getNested     = util.getNested,
    walkAndInvoke = util.walkAndInvoke,
    getHash       = util.getHash,
    substring     = String.prototype.substring,
    isString      = _.isString,
    isArray       = _.isArray,
    LIGHT_CHECK   = /iget2/;

module.exports = function(arg) {

    if(!LIGHT_CHECK.test(arg.data)) {
        return [];
    }

    var content  = arg.data,
        filePath = arg.path,
        ast      = esprima.parse(content, { range: true, loc: true }),
        result   = [];

    walkAndInvoke(ast, ['type', 'CallExpression'], function(node) {

        var nested    = getNested.bind(null, node),
            checkNode = checkConditions.bind(null, nested),
            fragment  = substring.apply(content, node.range),
            location  = nested('loc.start'),
            keyset,
            key,
            phrase,
            params;

        // iget2('keyset', 'key', 'phrase', params)
        if(checkNode(
            ['callee.name', 'iget2']
        )) {
            keyset = nested('arguments.0.value');
            key    = nested('arguments.1.value');
            phrase = nested('arguments.2.value');
            params = nested('arguments.3.properties');
        }
        else {
            return;
        }

        params = !isArray(params) ? false : params.reduce(function(obj, item) {
            obj[getNested(item, 'key.name')] = getNested(item, 'value.value');
            return obj;
        }, {});

        result.push({
            type: 'bem',
            hash: getHash(node, filePath),
            path: filePath,
            fragment: fragment,
            range: node.range,
            location: [location.line, location.column],
            upload: null,
            single: (isString(keyset) && isString(key)) || null,
            keyset: isString(keyset) ? keyset : null,
            key: isString(key) ? key : null,
            value: null,
            comment: null,
            context: null,
            plural: null,
            params: params,
            phrase: phrase
        });
    });

    return result;
};

function checkConditions(getValue, assertions) {

    assertions = [].slice.call(arguments, 1);

    return assertions.every(function(assertion) {
        return getValue(assertion[0]) === assertion[1];
    });
}
