BEM.DOM.decl({ block: 'i-glue-field_type_array', baseBlock: 'i-glue-field' }, {
    onSetMod: {
        js: function() {
            this.__base();

            this._fieldBlocks = this.findBlocksInside(this.params.bindType);
            this._blocksHelper = this._getBlocksProcessHelper();
        }
    },

    /**
     * Инициализирует блок i-glue-field
     * @protected
     * @param {Object} model
     */
    init: function(model) {
        this.__base.apply(this, arguments);
        this._glueBlocks();
    },

    /**
     * колбек на изменение прослушиваемого поля модели
     * устанавливает значение каждого элемента поля в соответствующий блок
     * @param {Object} e
     * @param {Object} data
     */
    onFieldChange: function(e, data) {
        this.model.get(this.name).forEach(function(val, idx) {
            this._blocksHelper.setBlockValue(this._fieldBlocks[idx], val);
        }, this);
    },

    /**
     * связывает каждый блок с элементом поля модели
     * @private
     */
    _glueBlocks: function() {
        this._fieldBlocks.forEach(function(block, index) {
            this._blocksHelper.glueBlock(block, index, this);
        }, this);
    },

    /**
     * колбек на изменение значения блока,
     * выставляет значение соответствующего элемента поля модели
     * @param {Object} e событие
     * @param {Number} e.data.index индекс элемента которому соответствует блок
     * @private
     */
    _onBlockChange: function(e) {
        var modelFieldValue = this.model.get(this.name);

        modelFieldValue[e.data.index] = e.block.val();
        this.model.set(this.name, modelFieldValue);
    },

    /**
     * возвращает хелпер для работы с блоками
     * @returns {*}
     * @private
     */
    _getBlocksProcessHelper: function() {
        var bindOnChange = function(block, index, field) {
                return block.on('change', { index: index }, field._onBlockChange, field);
            },
            setValueOnBluredBlock = function(block, val) {
                block.getMod('focused') !== 'yes' && block.val(val);
            },
            /**
             * хелпер для работы с блоками
             * ключ - тип блока
             * @todo если функционал будет усложняться стоит вынести в отдельный класс
             */
            blocksProcessHelper = {
                input: {
                    glueBlock: function(block, index, field) {
                        bindOnChange(block, index, field)
                            .on('blur', function() {
                                block.val(field.model.get(field.name, 'format')[index]);
                            }, this);
                    },
                    setBlockValue: setValueOnBluredBlock
                },
                select: {
                    glueBlock: bindOnChange,
                    setBlockValue: setValueOnBluredBlock
                },
                checkbox: {
                    glueBlock: bindOnChange,
                    setBlockValue: function(block, val) {
                        block.getMod('focused') !== 'yes' && block.setMod('checked', val ? 'yes' : '');
                    }

                }
            };

        return blocksProcessHelper[this.params.bindType] || blocksProcessHelper.input;
    }
});
