/**
 * Клей для контролов где записаны минус-слова.
 * При изменении контрола записывает минус-слова в модель как массив
 * При изменении модели записыает минус-слова в контрол как строку в правильном формате
 */
BEM.DOM.decl({ block: 'i-glue-field_type_minus-words', baseBlock: 'i-glue-field' }, {

    onSetMod: {
        js: function() {
            this.__base();

            this.input = this.findBlockInside('input');
        }
    },

    init: function(model) {
        this.__base.apply(this, arguments);

        this.input.on('change', function() {
            this.model.set(this.name, u.minusWords.stringToArray(this.input.val()));
        }, this);

        // причесывает значение в строке инпута
        this.input.on('blur', function() {
            this.input.val(u.minusWords.arrayToString(this.model.get(this.name) || []));
        }, this);
    },

    onFieldChange: function(e, data) {
        if (this.input.getMod('focused') !== 'yes') {
            this.input.val(data.value ? u.minusWords.arrayToString(data.value) : '');
        }
    }

});
