describe('i-glue-field_type_minus-words', function() {
    var model,
        modelName = 'm-glue-field-minus-words-test',
        instanceId = modelName + '-ID-0',
        block,
        clock,
        inputBlock,
        constStub;

    function createBlock() {
        var blockBemJson = {
                block: 'b-glued-field',
                mix: [{
                    block: 'i-glue',
                    js: {
                        modelName: modelName,
                        modelId: instanceId
                    }
                }],
                js: true,
                content: {
                    block: 'input',
                    mods: { type: 'textarea', size: 's' },
                    value: '',
                    mix: [{
                        block: 'i-glue',
                        elem: 'model-field',
                        js: {
                            name: 'words',
                            type: 'minus-words'
                        }
                    }],
                    content: { elem: 'control' }
                }
            };

        block = BEM.DOM.init(u.getDOMTree(blockBemJson).appendTo($('body'))).bem('b-glued-field');
        inputBlock = block.findBlockInside('input');
    }

    // Тип "minus-words" для поля "words" не указывается потому что поля типа "minus-words"
    // имеют собственный препроцессинг данных (из строки в массив)
    BEM.MODEL.decl(modelName, { words: 'array' });

    beforeEach(function() {
        // выпилить после открытия на всех DIRECT-51480
        constStub = sinon.stub(u, 'consts');
        constStub.withArgs('rights').returns({
            canAddMinusPhrases: true
        });

        model = BEM.MODEL.create({ name: modelName, id: instanceId }, { words: [] });
        createBlock();
        clock = sinon.useFakeTimers();
        clock.tick(100);
    });

    afterEach(function() {
        constStub.restore();

        model.destruct();
        clock.restore();
        block.destruct();
    });

    it('При изменении контрола меняется модель', function() {
        inputBlock.val('-a -b');
        expect(model.get('words')).to.have.members(['a','b']);
    });

    it('При изменении модели меняется контрол', function() {
        model.set('words', ['c', 'd']);
        expect(inputBlock.val()).to.eql('-c -d');
    });

});
