BEM.DOM.decl({ block: 'i-glue-field_type_radio-button', baseBlock: 'i-glue-field' }, {
    onSetMod: {
        js: function() {
            this.__base();

            this._radioButton = this.findBlockOn('radio-button');
        }
    },

    /**
     * Инициализация блока
     */
    init: function() {
        this.__base.apply(this, arguments);

        this._radioButton.on('change', function() {
            this.model.set(this.name, this._radioButton.val());
        }, this);
    },

    /**
     * Установка значения контролла
     * @param {String} value
     */
    set: function(value) {
        this.__base();
        this._radioButton.val(value);
    },

    /**
     * Реакция на изменение модели
     * @param {Object} e
     * @param {Object} data
     * @param {String} data.value
     */
    onFieldChange: function(e, data) {
        this._radioButton.getMod('focused') !== 'yes' && this._radioButton.val(data.value);
    }

});
