describe('i-glue-field_type_radio-button', function() {
    var model,
        block,
        clock,
        radiobutton;

    function createBlock() {
        var blockBemJson = {
                block: 'b-glued-field',
                mix: [{
                    block: 'i-glue',
                    js: {
                        modelName: 'glue-field-radiobutton-model',
                        modelId: 'glue-field-radiobutton-model-id'
                    }
                }],
                js: true,
                content: {
                    block: 'radio-button',
                    mix: [{
                        block: 'i-glue',
                        elem: 'model-field',
                        js: {
                            name: 'str',
                            type: 'radio-button'
                        }
                    }],
                    content: [
                        {
                            elem: 'radio',
                            controlAttrs: { value: 'val1' },
                            content: 'val1'
                        },
                        {
                            elem: 'radio',
                            controlAttrs: { value: 'val2' },
                            content: 'val2'
                        }
                    ]
                }
            };

        block = BEM.DOM.init(u.getDOMTree(blockBemJson).appendTo($('body'))).bem('b-glued-field');
        radiobutton = block.findBlockInside('radio-button');
    }

    BEM.MODEL.decl('glue-field-radiobutton-model', {
        num: 'number',
        str: 'string',
        bool: 'boolean'
    });

    beforeEach(function() {
        model = BEM.MODEL.create({ name: 'glue-field-radiobutton-model', id: 'glue-field-radiobutton-model-id' }, {
            num: 1,
            str: 'val',
            bool: false
        });

        createBlock();
        clock = sinon.useFakeTimers();
    });

    afterEach(function() {
        model.destruct();
        clock.restore();
        block.destruct();
    });

    it('При изменении контрола меняется модель', function() {
        radiobutton.val('val1');
        clock.tick(100);
        expect(model.get('str')).to.be.equal('val1');
    });

    it('При изменении модели меняется контрол', function() {
        model.set('str', 'val2');
        clock.tick(100);
        expect(radiobutton.val()).to.be.equal('val2');
    });

});
