BEM.DOM.decl({ block: 'i-glue-field_type_tumbler', baseBlock: 'i-glue-field' }, {
    onSetMod: {
        js: function() {
            this.__base();

            this._tumbler = this.findBlockOn('tumbler');
        }
    },

    /**
     * Инициализация блока
     */
    init: function() {
        this.__base.apply(this, arguments);

        this._tumbler.on('change', function(e, data) {
            this.model.set(this.name, this.params.inverse ? !data.checked : data.checked );
        }, this);
    },

    /**
     * Установка значения контролла
     * @param {Boolean} value
     */
    set: function(value) {
        this.__base();
        this._tumbler.val(value);
    },

    /**
     * Реакция на изменение модели
     * @param {Object} e
     * @param {Object} data
     * @param {Boolean} data.value
     */
    onFieldChange: function(e, data) {
        // cyn@TODO: В DIRECT-53578 оторвать disable-next-line и починить
        // eslint-disable-next-line no-undef
        this._tumbler.getMod('focused') !== 'yes' && this._tumbler.val(this.params.inverse ? !data.value : data.value);
    }

});
