#Логирование информации со страницы

На Директе есть возможность отправлять на бэкенд информацию со страницы для её хранения и последующего изучения.

Ручка доступна по адресу `/log-js`. Пример вызова: 

`/log-js?reqid=123423&data={%22asd%22:213}&type=render`

Принимает параметры:

* `reqid` uint64 — приходит на все страницы в переменных
* `type` — тип записи:
    * `render` — скорость отрисовки страницы
    * `errors` — js-ошибки на странице
* `data` — валидный json, размером не больше 10Kb

Возвращает: `{"status": "ok"}`

В качеcтве точки отсчета выбираем время `js-zero-time`, которое вычисляется путем вставки тега script в head страницы и получением системного времени

##Render data
Сейчас в data отправляются слудующие данные (все значения в милисекундах):

* `direct.js-init-start` — время от точки `js-zero-time` до начала выполнения основного скрипта `direct.js` (вставлено в файл первой строчкой)
* `direct.js-init-time` — время выполнения js-кода в `direct.js` (разница между временем исполнения первой и последней строчки в файле)
* `dom-ready` — время от `js-zero-time` до конца инициализации DOM, берется из jquery-события `$(document).ready()`
* `bem-init-time` — время инициализации i-bem-блоков на странице, не учитываются блоки с отложенной инициализацией (время выполнения первого вызова `BEM.DOM.init()`)
* `window-loaded` — время от `js-zero-time` до срабатывания события window.onload
* `unload` — время от `js-zero-time` срабатывания события window.onunload


##Отправка данных
В настоящий момент данные отправляются до двух раз:
  Во-первых при инициализации, то есть либо при завершении инициализации блоков, либо при `onload` если он наступил раньше.
  Во-вторых на `unload`. Если unload случился раньше инициализации, или какое-то из последний событий (`window-load, bem-init`) не сработало вообще, то на `unload` отправляются все собранные данные. Если данные уже отправились при инициализации, то на unload отправится только время срабатывания unload (само время нам не особо нужно, оно лишь служит меткой что данные отправились именно при `unload`)


##Логирование ошибок

Ошибки (Exception'ы) отправляются также на `/log-js` c указанием параметра `type=errors`
Отправляются только из браузеров поддерживающих `window.onerror`, и соответсвенно отправляются при его вызове.
С одного захода на страницу не отправляется более трёх ошибок, остальные просто игнорируются.
В `data` отправляются `message, url, line` соответствующие параметрам приходящим в `onerror`.

DIRECT-20786[ --i-time-logger: Логирование скорости работы клиентской стороны-- ]( cranx )
