(function() {
    u.register({
        /**
         * Возвращает функцию, получающую значение по ключу name из переданного объекта obj
         * В случае, если obj[name] - функция, вызывает ее с переданными аргументами arg1, arg2, ...
         *
         * @example
         * <pre>
         *
         * var objects = [{ a: 1 }, { a: 2 }, { a: 3 }];
         * objects.map(getter('a')) //--> [1, 2, 3]
         * </pre>
         *
         * @example
         * <pre>
         * Искусственный пример, иллюстрирующий вызов функции
         * var objects = [{ get: function(first) { return first ? this.data[0]: this.data[1]; }, data: [1, 2]}];
         * objects.map(getter('get', true))  //--> [1]
         * objects.map(getter('get', false)) //--> [2]
         * </pre>
         *
         * @param {String} name
         * @returns {Function}
         */
        getter: function(name/*, arg1, arg2, ...*/) {
            var args = Array.prototype.slice.call(arguments, 1);
            return function(obj) {
                return typeof obj[name] === 'function' ? obj[name].apply(obj, args) : obj[name];
            };
        }
    });
})();
