describe('i-utils__function', function() {
    describe('getter', function() {
        var getter = BEM.blocks['i-utils'].getter,
            getterInstance = getter('param');

        it('must return value, if param is primitive or object', function() {
            expect(getterInstance({ param: 123 })).to.be.equal(123);
            expect(getterInstance({ param: '123' })).to.be.equal('123');
            expect(getterInstance({ param: { param: 'value' } })).to.be.eql({ param: 'value' });
        });

        it('must return result of a function call, if param is function', function() {
            expect(getterInstance({ param: function() { return 123; } })).to.be.equal(123);
        });

        it('must pass arguments to called function', function() {
            expect(getter('param', '1', '2', '3')({ param: function(a, b, c) { return a + b + c; } })).to.be.equal('123');
        });
    });
});
