(function() {
    /**
     * Группирует массив по ключам, возвращаемым keyFn
     * Не изменяет исходный массив
     *
     * @example
     * groupBy([{ name: 1, value: 1 }, { name: 1, value: 2 }, { name: 2, value: 3 }], function(item) {
     *     return item.name;
     * }) -> { 1: [{ name: 1, value: 1 }, { name: 1, value: 2 }], 2: [{ name: 2, value: 3 }] }
     * @param {*[]} array исходный массив
     * @param {function(keySubject)} keyFn функция отображения элемента массива в ключ
     * @returns {Object} хэш с группами(ключи хэша - ключи группы, содержимое по ключу - массив элементов)
     */

    u.register({ groupBy:
        function(array, keyFn) {
            return array.reduce(function(res, next) {
                var key = keyFn(next);

                res[key] ?
                    res[key].push(next) :
                    res[key] = [next];

                return res;
            }, {});
        }
    });
})();
