block('app-main')(

    def()(function() {

        //DIRECT-31037
        //javascript парсер воспринимает символы \u2028 и \u2029 как перевод строки
        //перевода строки в литерале строки синтаксически некорректен, заменяем его на \n
        var data = this.data = typeof this.ctx.data == 'string' ?
                JSON.parse(this.ctx.data.replace(/\u2028|\u2029/g, '\\n')) :
                this.ctx.data,
            pageBlock,
            iGlobalBemjson;

        Object.keys(this.ctx.funcs).forEach(function(key) {
            data[key] = this.ctx.funcs[key];
        }, this);

        //i-utils должны подключится прежде, чем начнет выполняться preprocess
        applyCtx({
            block: 'i-utils'
        });

        // Получаем название страничного блока (и его модификаторы)
        // Нужно иметь в виду, что данные внутри этой моды еще не обработаны по схемам и модой preprocess
        pageBlock = apply('page-block');

        if (typeof pageBlock === 'string') {
            pageBlock = {
                block: pageBlock
            };
        }

        this.ctx.pageBlock = pageBlock;
        this.ctx.isFooterEnabled = apply('is-footer-enabled');
        this.ctx.isHeaderEnabled = apply('is-header-enabled') !== undefined ? apply('is-header-enabled') : true;
        this.ctx.hideChatOnPage = Boolean(apply('hide-chat-on-page'));
        this.ctx.isDnaHeaderAndSidebarEnabled = apply('is-dna-header-and-sidebar-enabled');

        //Преобразование данных по схемам
        apply('schema-validation');

        // Заполняются глобальные параметры и константы, переменная нужна для передачи их в bemhtml
        iGlobalBemjson = applyCtx({
            block: 'i-global'
        });

        // Инициализация валют (теперь они в bricks, а там нельзя использовать u.consts)
        // должна быть после инициализации i-global (т.к. внутри используются константы),
        // при этом до выполнения моды `preprocess` (т.к. в preprocess некоторых блоков используется получении валюты)
        u.currencies.init({
            currencies: u.consts('currencies'),
            pseudoCurrency: u.consts('pseudo_currency'),
            currencyTextsDescription: u.consts('currency_texts_description'),
            fixedCurrencyRates: u.consts('fixed_currency_rates'),
            locationNameI18N: iget2
        });

        // Предобработка данных
        data = apply('preprocess');

        return [
            iGlobalBemjson,
            applyCtx(apply('content'))
        ];
    }),

    mode('schema-validation')(function() {
        var data = this.data,
            pageBlock = this.ctx.pageBlock,
            blocksForValidation = ['i-global', 'i-utils', pageBlock];

        /**
         * Предварительная обработка данных по схеме (приведение типов и эксейпинг)
         * @param {Object} segment Фрагмент схемы данных
         * @param {*} obj Данные, соответствующие текущему фрагменту данных
         * @param {String|Number} [prop] Поле данных, соответствующее текущему фрагменту данных
         * @returns {Boolean} флаг, показывающий были ли произведены преобразования или нет
         */
        var processBySchema = function(segment, obj, prop) {
                var val,
                    valType,
                    types,
                    processed,
                    name,
                    props,
                    field,
                    pattern,
                    patterns,
                    safe,
                    regexp;

                if (!obj || prop !== undefined && (obj[prop] === undefined || obj[prop] === null) || !segment) {
                    return false;
                }

                segment.$ref && (segment = u.tv4.getSchema(segment.$ref) || {});

                val = prop !== undefined ? obj[prop] : obj;

                valType = typeof val;

                // если имеется перечисление типов, например, ["boolean", "number"],
                // то необходимо просмотреть возможности приведения к одному из
                // указанных типов в том порядке, в котором они объявлены
                if (Array.isArray(segment.type)) {
                    types = segment.type;

                    // проход до конца или до первого удачного преобразования
                    processed = types.some(function(type) {
                        // подмена типа для проверки и применения преобразования
                        segment.type = type;

                        return processBySchema(segment, obj, prop);
                    });

                    // возврат списка типов для валидатора
                    segment.type = types;

                    return processed;
                }

                // обработка объектов
                if (valType === 'object' &&
                    (segment.type === 'object' || segment.properties || segment.patternProperties)) {

                    props = segment.properties || {};
                    patterns = segment.patternProperties || {};

                    for (name in props) {
                        val[name] !== undefined && processBySchema(props[name], val, name);
                    }

                    for (pattern in patterns) {
                        regexp = new RegExp(pattern);

                        for (field in val) {
                            regexp.test(field) && processBySchema(patterns[pattern], val, field);
                        }
                    }

                    // секция отработала без исключительных ситуаций, преобразования произведены
                    return true;
                }

                // обработка элементов массивов
                if (segment.type === 'array' && Array.isArray(val)) {
                    val.forEach(function(v, i) {
                        processBySchema(segment.items, val, i);
                    });

                    // секция отработала без исключительных ситуаций,
                    // это действительно массив и преобразования произведены
                    return true;
                }

                // обработка экранирования строк
                if (segment.type === 'safe-string' && !val.__raw) {
                    safe = new String(u.escapeHTML(val));

                    safe.__raw = val;
                    safe.link = undefined;
                    obj[prop] = safe;

                    // секция отработала без исключительных ситуаций, преобразования произведены
                    return true;
                }

                // костыль @skywhale: DIRECT-51103
                // тоже обработка экранирования строк, возвращает строку
                if (segment.type === 'compact-safe-string' && !val.__raw) {
                    obj[prop] = new String(u.escapeHTML(val)).toString();

                    // секция отработала без исключительных ситуаций, преобразования произведены
                    return true;
                }

                // если значение уже соответствует указанному примитивному типу, то выходим
                if (valType === segment.type) {
                    return true;
                }

                // обработка примитивных типов
                switch (segment.type) {
                    case 'string':
                        val && typeof val.toString === 'function' && (val = val.toString());

                        break;
                    case 'number':
                        val = +val;

                        // если это не число, делаем так, чтобы typeof не отдал number
                        isNaN(val) && (val = null);

                        break;
                    case 'boolean':
                        val = valType === 'string' && /^(true|yes)$/.test(val.toLowerCase()) || !!+val;

                        break;
                }

                // преобразования могут быть произведены,
                // только если получили требуемый тип
                processed = typeof val === segment.type;

                // если все хорошо, то применяем преобразование
                processed && (obj[prop] = val);

                return processed;
            },

            /**
             * Возвращает копию переменной
             * @param {*} val
             **/
            clone = function(val) {
                var copy = {};

                if (typeof val === 'object') {

                    if (val instanceof String) {
                        var str = new String(val);

                        str.link = undefined;

                        return str;
                    }

                    if (val instanceof Array) return val.concat();

                    for (var field in val) {
                        val.hasOwnProperty(field) &&
                            (copy[field] = typeof val[field] === 'object' ? clone(val[field]) : val[field]);
                    }

                    return copy;
                } else {

                    return val;
                }
            },

            /**
             *  "Deep extend" объекта
             **/
            deepExtend = function(src) {
                if (typeof src !== 'object') return;

                for (var field in src) {
                    var val = src[field];

                    if (!this[field]) {
                        this[field] = clone(val);

                    } else if (typeof val === 'object') {
                        deepExtend.call(this[field], val);
                    }
                }
            };

        var computedSchema = {
                properties: {}
            },
            schemas = data.read_schema_bundle ? data.read_schema_bundle() : data.json_schema;

        data.schemas = {};

        Object.keys(schemas).forEach(function(key) {
            u.tv4.addSchema(key, schemas[key]);
        }, this);

        if (schemas[data.cmd]) { //схемы на контроллеры
            schemas = [schemas['global-vars'], schemas[data.cmd]];

            schemas.forEach(function(schema) {
                deepExtend.call(computedSchema.properties, schema.properties);
                processBySchema(schema, data);
            });
        } else { //схемы на страницы
            blocksForValidation.forEach(function(block) {
                if (!block) return;

                var schema,
                    blockWithMod,
                    modName,
                    schemaForMod;

                // если блок с модификатором, смотрим, нет ли базовой схемы чтобы её доопределить DIRECT-41250
                if (block.block && block.mods) {
                    modName = Object.keys(block.mods)[0];
                    blockWithMod = block.block + '_' + modName + '_' + block.mods[modName];
                    schemaForMod = schemas[blockWithMod];

                    if (schemaForMod) {
                        if (schemaForMod.base) {
                            schema = this.extend(schemas[schemaForMod.base], schemaForMod);
                        } else {
                            schema = schemaForMod;
                        }
                    }
                }

                if (!schema) schema = schemas[block.block || block];

                if (!schema) return;

                deepExtend.call(computedSchema.properties, schema.properties);
                processBySchema(schema, data);
            }, this);
        }
    }),

    mode('preprocess')(function() {
        return this.data;
    }),

    mode('page-block')(undefined),

    mode('is-footer-enabled')(true)

);
