BEM.DOM.decl({ block: 'attach', modName: 'cut', modVal: 'yes' }, {

    /**
     * Задаёт метку прикреплённого файла
     * Переопределён для ограничения длины текста
     * @param {String} fileName
     * @private
     * @override
     */
    _setFile: function(fileName) {
        var defaultLimit = 20,
            tailLen = 5,
            hellipLen = 3,
            limit = this.params.limit || defaultLimit,
            offset;

        if (fileName && fileName.length > limit) {
            offset = limit - tailLen - hellipLen;

            this.delMod(this.elem('holder'), 'state');

            BEM.DOM.update(this.elem('text'), BEMHTML.apply([
                fileName.slice(0, offset),
                {
                    block: 'attach',
                    elem: 'text-hellip',
                    tag: 'span',
                    content: {
                        elem: 'text-cut',
                        tag: 'span',
                        content: fileName.slice(offset, -tailLen)
                    }
                },
                fileName.slice(-tailLen)
            ]));
        } else {
            this.__base.apply(this, arguments);
        }
    }

});
