block('b-account-score')(
    def()(function() {
        this.ctx.verdicts = {
            stop_days: {
                title: iget2('b-account-score', 'izbegayte-ostanovki-reklamy', 'Избегайте остановки рекламы.'),
                recommendation: iget2(
                    'b-account-score',
                    'vy-ne-zabyli-zapustit',
                    'Вы не забыли запустить показы рекламы? Когда кампания часто простаивает без показов, она становится неэффективной и за неделю вы можете потерять {num} месячной аудитории.</br>Возможно, показы останавливаются из-за нехватки средств. Чтобы размещение шло по плану, выбирайте {help}, при которых деньги быстрее поступают на счёт.',
                    {
                        num: function(text) {
                            return {
                                block: 'b-quality-verdicts-list',
                                elem: 'bold',
                                content: text
                            };
                        }('23%'),

                        help: function(text) {
                            return {
                                block: 'link',
                                url: u.getCommonHelpUrl('/direct/payments/payment-methods.xml'),
                                content: text,
                                attrs: {
                                    target: '_blank'
                                }
                            };
                        }(iget2('b-account-score', 'vy-ne-zabyli-zapustit-param-help', 'способы оплаты')),

                        context: 'num - 23%; help - способы оплаты'
                    }
                )
            },
            avg_banners: {
                title: iget2(
                    'b-account-score',
                    'izmenite-teksty-obyavleniy-chtoby',
                    'Измените тексты объявлений, чтобы не терять потенциальных посетителей.'
                ),
                recommendation: iget2(
                    'b-account-score',
                    'po-statistike-vy-mozhete',
                    'По статистике вы можете недополучить целых {num} трафика, показывая по разнообразным запросам общее описание. Если человек ищет пароварку, ему важно увидеть рекламу именно такого товара, а не всего магазина техники. Разбейте свои ключевые слова на группы (например, по маркам или моделям) и напишите для них объявления о конкретных товарах или услугах. {help}.',
                    {
                        num: function(text) {
                            return {
                                block: 'b-quality-verdicts-list',
                                elem: 'bold',
                                content: text
                            };
                        }('33%'),

                        help: function(text) {
                            return {
                                block: 'link',
                                url: u.getCommonHelpUrl('/direct/efficiency/increase-profit.xml'),
                                content: text,
                                attrs: {
                                    target: '_blank'
                                }
                            };
                        }(iget2('b-account-score', 'po-statistike-vy-mozhete-param-help', 'Другие советы об эффективности')),

                        context: 'num - 33%; help - Другие советы об эффективности'
                    }
                )
            },
            avg_phrases: {
                title: iget2('b-account-score', 'napishite-dlya-klyuchevyh-fraz', 'Напишите для ключевых фраз разные тексты.'),
                recommendation: iget2(
                    'b-account-score',
                    'po-statistike-vy-mozhete-100',
                    'По статистике вы можете недополучить целых {num} трафика, показывая по разнообразным запросам общее описание. Если человек ищет пароварку, ему важно увидеть рекламу именно такого товара, а не всего магазина техники. Разбейте свои ключевые слова на группы (например, по маркам или моделям) и напишите для них объявления о конкретных товарах или услугах. Чтобы объявления лучше соответствовали запросам пользователей, можно использовать {templates} — так для каждой ключевой фразы будет показываться свой уникальный текст. {help}',
                    {
                        num: function(text) {
                            return {
                                block: 'b-quality-verdicts-list',
                                elem: 'bold',
                                content: text
                            };
                        }('33%'),

                        templates: function(text) {
                            return {
                                block: 'link',
                                url: u.getCommonHelpUrl('/direct/features/ad-templates.xml'),
                                content: text,
                                attrs: {
                                    target: '_blank'
                                }
                            };
                        }(iget2('b-account-score', 'po-statistike-vy-mozhete-100-param-templates', 'шаблоны')),

                        help: function(text) {
                            return [
                                '</br>',
                                {
                                    block: 'link',
                                    url: u.getCommonHelpUrl('/direct/efficiency/increase-profit.xml'),
                                    content: text,
                                    attrs: {
                                        target: '_blank'
                                    }
                                }
                            ];
                        }(iget2('b-account-score', 'po-statistike-vy-mozhete-100-param-help', 'Другие советы об эффективности.')),

                        context: 'num - 33%; templates - шаблоны; help - Другие советы об эффективности.'
                    }
                )
            },
            sitelinks: {
                title: iget2('b-account-score', 'bystrye-ssylki-mogut-uvelichit', 'Быстрые ссылки могут увеличить трафик на {num}', {
                    num: function(text) {
                        return {
                            block: 'b-quality-verdicts-list',
                            elem: 'bold',
                            content: text
                        };
                    }('30%'),

                    context: 'num - 30%'
                }),
                recommendation: iget2(
                    'b-account-score',
                    'help-bystrye-ssylki-pomogut',
                    '{help} помогут вам сразу отправлять посетителей в нужный им раздел сайта. Например, на список предложений, условия оплаты или специальные акции. По нашим наблюдениям, такие ссылки заметно повышают интерес аудитории и приводят на сайт гораздо больше заинтересованных пользователей.',
                    {
                        help: function(text) {
                            return {
                                block: 'link',
                                url: u.getCommonHelpUrl('/direct/features/quick-links.xml'),
                                content: text,
                                attrs: {
                                    target: '_blank'
                                }
                            };
                        }(iget2('b-account-score', 'help-bystrye-ssylki-pomogut-param-help', 'Быстрые ссылки')),

                        context: 'help - Быстрые ссылки'
                    }
                )
            },
            images: {
                title: iget2('b-account-score', 'dobavte-k-obyavleniyam-illyustracii', 'Добавьте к объявлениям иллюстрации.'),
                recommendation: iget2(
                    'b-account-score',
                    'podberite-k-svoim-obyavleniyam',
                    'Подберите к своим объявлениям хорошие {help}: фото рекламируемых товаров или картинки, подходящие к тематике услуг. Они повышают кликабельность {num}. Люди будут чаще замечать вашу рекламу и лучше поймут, что именно вы предлагаете им в каждом конкретном случае.',
                    {
                        help: function(text) {
                            return {
                                block: 'link',
                                url: u.getCommonHelpUrl('/direct/features/images.xml'),
                                content: text,
                                attrs: {
                                    target: '_blank'
                                }
                            };
                        }(iget2('b-account-score', 'podberite-k-svoim-obyavleniyam-param-help', 'изображения')),

                        num: function(text) {
                            return {
                                block: 'b-quality-verdicts-list',
                                elem: 'bold',
                                content: text
                            };
                        }(iget2('b-account-score', 'podberite-k-svoim-obyavleniyam-param-num', 'до 2,5 раз')),

                        context: 'help - изображения; num - до 2,5 раз'
                    }
                )
            },
            ctx_price_coef: {
                title: iget2('b-account-score', 'pereraspredelite-byudzhet-kampanii', 'Перераспределите бюджет кампании.'),
                recommendation: iget2(
                    'b-account-score',
                    'po-nashim-nablyudeniyam-optimalnyy',
                    'По нашим наблюдениям, оптимальный бюджет на показы {help} составляет {num} от бюджета кампании на поиске.</br>Уменьшая это ограничение, вы теряете потенциальных посетителей.',
                    {
                        num: function(text) {
                            return {
                                block: 'b-quality-verdicts-list',
                                elem: 'bold',
                                content: text
                            };
                        }(iget2('b-account-score', 'po-nashim-nablyudeniyam-optimalnyy-param-num', 'не менее 16%')),

                        help: function(text) {
                            return {
                                block: 'link',
                                url: u.getCommonHelpUrl('/direct/general/yan.xml'),
                                content: text,
                                attrs: {
                                    target: '_blank'
                                }
                            };
                        }(iget2('b-account-score', 'po-nashim-nablyudeniyam-optimalnyy-param-help', 'в сетях')),

                        context: 'help - в сетях; num - не менее 16%'
                    }
                )
            },
            separate_place: {
                title: iget2('b-account-score', 'razdelyayte-kampanii-na-poisk', 'Разделяйте кампании на поиск и сети.'),
                recommendation: iget2(
                    'b-account-score',
                    'na-raznyh-tipah-ploshchadok',
                    'На разных типах площадок различаются принципы показа и поведение аудитории. Если их не учитывать, реклама заинтересует меньше людей.</br> Например, без отдельных настроек для сетей вы теряете {num} трафика. Для них можно и нужно создавать более яркие продающие тексты, не так сильно сужать ключевые запросы с помощью операторов и предусмотреть некоторые другие особенности размещения. Разделяйте кампании на поиск и сети, следуя рекомендациям в нашем {help}. Так вы сможете привлекать максимум целевой аудитории и не переплачивать за нее.',
                    {
                        help: function(text) {
                            return {
                                block: 'link',
                                url: iget2('b-account-score', 'http-adv-ya-ru', 'http://adv.ya.ru/replies.xml?item_no=2048'),
                                content: text,
                                attrs: {
                                    target: '_blank'
                                }
                            };
                        }(iget2('b-account-score', 'na-raznyh-tipah-ploshchadok-param-help', 'блоге')),

                        num: function(text) {
                            return {
                                block: 'b-quality-verdicts-list',
                                elem: 'bold',
                                content: text
                            };
                        }(iget2('b-account-score', 'na-raznyh-tipah-ploshchadok-param-num', 'до 43%')),

                        context: 'num - до 43%; help - блоге'
                    }
                )
            },
            vcards: {
                title: iget2('b-account-score', 's-virtualnoy-vizitkoy-reklama', 'С виртуальной визиткой реклама заметнее'),
                recommendation: iget2(
                    'b-account-score',
                    'help-vizitka-odin-iz',
                    '{help} — один из самых простых способов повысить эффективность объявления на поиске Яндекса и помочь пользователям легко найти вас на Яндекс.Картах. Создайте её для своей рекламы, чтобы дать аудитории максимум информации о себе и привлечь до {num} больше посетителей.',
                    {
                        num: function(text) {
                            return {
                                block: 'b-quality-verdicts-list',
                                elem: 'bold',
                                content: text
                            };
                        }('12%'),

                        help: function(text) {
                            return {
                                block: 'link',
                                url: u.getCommonHelpUrl('/direct/features/vcards.xml'),
                                content: text,
                                attrs: {
                                    target: '_blank'
                                }
                            };
                        }(iget2('b-account-score', 'help-vizitka-odin-iz-param-help', 'Визитка')),

                        context: 'help - Визитка; num - 12%'
                    }
                )
            }
        };

        this.data.account_score.score && (this.data.account_score.score = u.formatPrice(this.data.account_score.score));

        this.data.account_score.prev_score &&
            (this.data.account_score.prev_score = u.formatPrice(this.data.account_score.prev_score));

        return applyNext();
    }),

    addJs()(true),

    content()(function() {
        return (!!this.data.account_score && this.data.account_score.score || this.data.account_score.score === 0) && [
            {
                elem: 'score',
                content: [
                    this.data.account_score.score,
                    !!this.data.account_score.progress && {
                        block: 'b-icon',
                        mix: [{
                            block: 'b-account-score',
                            elem: 'arrow'
                        }],
                        mods: {
                            type: 'arrow',
                            arrow: this.data.account_score.progress == 1 ? 'up' : 'down'
                        }
                    }
                ]
            },
            {
                block: 'dropdown',
                content: [
                    {
                        block: 'link',
                        mix: [{
                            block: 'dropdown',
                            elem: 'switcher'
                        }],
                        content: iget2('b-account-score', 'povysit-nbsp-kachestvo-akkaunta', 'Повысить&nbsp;качество аккаунта'),
                        mods: {
                            pseudo: 'yes',
                            theme: 'without-border'
                        }
                    },
                    { //выпадающее окно с произвольным содержимым
                        elem: 'popup',
                        // параметры блока `popup` в контексте `dropdown`
                        elemMods: { 'has-close': 'yes' },
                        js: {
                            directions: ['bottom']
                        },
                        content: {
                            block: 'b-quality-verdicts-list',
                            mix: [{
                                block: 'b-account-score',
                                elem: 'popup-content'
                            }],
                            title: [
                                iget2('b-account-score', 'kachestvo-akkaunta-mdash-s', 'Качество аккаунта &mdash; {foo}', {
                                    foo: this.data.account_score.score
                                }),
                                !!this.data.account_score.prev_score && {
                                    elem: 'sub-title',
                                    content: iget2('b-account-score', 'byl-s', 'Был {foo}', {
                                        foo: this.data.account_score.prev_score
                                    })
                                },
                                {
                                    elem: 'sub-title',
                                    content: {
                                        block: 'b-help-link',
                                        url: u.getHelpUrl('account-quality'),
                                        mods: {
                                            decoration: 'no',
                                            margin: 'no'
                                        },
                                        text: iget2('b-account-score', 'chto-takoe-kachestvo-akkaunta', 'Что такое качество аккаунта')
                                    }
                                }
                            ],
                            emptyText: '',
                            verdicts: this.data.account_score.verdicts ?
                                this.data.account_score.verdicts.map(function(name) {
                                    return this.ctx.verdicts[name];
                                }, this) : []
                        }
                    }
                ]
            }
        ];
    })
);
