BEM.DOM.decl({ block: 'b-add-ya-dialog-popup-adapter' }, {
    onSetMod: {
        js: function() {
            this._subMan = BEM.create('i-subscription-manager');

            u.graspSelf.call(this, {
                _btn: 'button on opener'
            });

            this._initPopup();
            this._initEvents();
        }
    },

    /**
     * Деструктор
     */
    destruct: function() {
        this._subMan.dispose();
        this._subMan.destruct();

        this.__base.apply(this);
    },

    _showPopup: function() {
        this._popupContent.prepareData(this._dialogsModel);
        this._popupDecorator.show();
    },

    /**
     * Инициализирует попап
     * @private
     */
    _initPopup: function() {
        if (!this._popupDecorator) {
            this._popupDecorator = BEM.DOM.blocks['b-modal-popup-decorator'].create2(undefined, { bodyScroll: false }, $);
            this._popupContent = this._popupDecorator.setPopupContent({
                block: 'b-add-ya-dialog-popup'
            });
        }
    },

    /**
     * Инициализирует события на блоке
     * @private
     */
    _initEvents: function() {
        var popup = this._popupDecorator;

        this._subMan
            .on(this._popupContent, 'close', function() {
                this._popupDecorator.hide({ force: true });
            }, this);

        this._subMan.wrap(popup)
            .on('close-blocked', function() {
                BEM.blocks['b-user-dialog']
                    .confirm({
                        message: iget2('b-add-ya-dialog-popup-adapter', 'u-vas-est-nesohranennye', 'У вас есть несохраненные изменения. Продолжить?'),
                        confrimButtonText: iget2('b-add-ya-dialog-popup-adapter', 'da-121', 'Да'),
                        cancelButtonText: iget2('b-add-ya-dialog-popup-adapter', 'net-122', 'Нет'),
                        parentPopup: popup.getPopup(),
                        onConfirm: function() {
                            popup.hide({ force: true });
                        },
                        callbackCtx: this
                    });
            }, this);
    },

    /**
     * Установка модели чатов извне
     */
    setDialogsModel: function(dialogsModel) {
        this._dialogsModel = dialogsModel;
    }

}, {
    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'button', function() {
            this._showPopup();
        });
    }
});
