BEM.DOM.decl({ block: 'b-add-ya-dialog-popup', implements: 'i-modal-popup-inner-block-interface' }, {
    onSetMod: {
        js: function() {
            this._subMan = BEM.create('i-subscription-manager');

            u.graspSelf.call(this, {
                _save: 'button on accept-button',
                _cancel: 'button on decline-button',
                _addDialog: 'b-add-ya-dialog inside'
            });

            this._initActions();
        },

        'add-request': function(modName, modVal) {
            if (modVal) {
                this._save.setText(u['b-add-ya-dialog-popup'].BTN_TEXT_ADDING);
            } else {
                this._save.setText(u['b-add-ya-dialog-popup'].BTN_TEXT_ADD);
            }
        }
    },

    /**
     * Деструктор
     */
    destruct: function() {
        this._subMan.dispose();
        this._subMan.destruct();
        this._addDialog.destruct();

        this.__base.apply(this);
    },

    /**
     * Были ли изменения
     * @returns {Promise}
     * @private
     */
    isChanged: function() {
        var deferred = $.Deferred(),
            isChanged = this._dialog !== this._addDialog.getDialog();

        deferred.resolve(isChanged);

        return deferred;
    },

    /**
     * Дергает метод инициализации добавления чата
     * @param {BEM.MODEL} dialogsModel
     */
    prepareData: function(dialogsModel) {
        this._dialogsModel = dialogsModel;
        this._addDialog.prepareToShow();
        this._save.setMod('disabled', 'yes');
    },

    /**
     * Инициализация обработчиков
     * @private
     */
    _initActions: function() {
        var unknownError = iget2('b-add-ya-dialog-popup', 'some-error','Произошла непредвиденная ошибка.');

        this._subMan
            .on(this._cancel, 'click', function() {
                this.trigger('close');
            }, this)

            .on(this._save, 'click', function() {
                this._save.setMod('disabled', 'yes');
                this.setMod('add-request', 'yes');
                u['b-ya-dialog-popup'].addDialog(u.consts('ulogin'), {
                    skillId: this._addDialog.getDialog()
                }).then(function(res) {

                    this.setMod('add-request', '');

                    if (res.dialog) {
                        this._dialogsModel.addNewDialog(res.dialog);

                        this.trigger('close');
                    } else if (res.validationResult) {
                        var error = res.validationResult.errors[0];

                        this.setMod('add-request', '');

                        if (error && error.code === 'DefectIds.OBJECT_NOT_FOUND') {
                            this._addDialog.updateErrors(iget2('b-add-ya-dialog-popup', 'invalid-chat-id','Некорректный идентификатор чата.'));
                        } else {
                            this._addDialog.updateErrors(unknownError);
                        }
                    } else {
                        this.setMod('add-request', '');
                        this._addDialog.updateErrors(unknownError);
                    }
                }.bind(this)).catch(function() {
                    this.setMod('add-request', '');
                    this._addDialog.updateErrors(unknownError);
                }.bind(this));
            }, this)

            .on(this._addDialog, 'canSave', function(e, canSave) {
                this._save.setMod('disabled', canSave ? '' : 'yes');
            }, this);
    }
});
