BEM.DOM.decl({ block: 'b-add-ya-dialog' }, {

    /**
     * @private
     * @type {Boolean}
     */
    _canSave: false,

    onSetMod: {
        js: function() {
            this._input = this.findBlockOn('input', 'input');

            this._input.on('change', function() {
                var inputValue = this._input.val().trim(),
                    hasValue = inputValue !== '';

                this._dialogId = inputValue;

                if (!this._canSave) {
                    this._canSave = hasValue;
                    this.trigger('canSave', hasValue);
                } else if (!hasValue) {
                    this._canSave = false;
                    this.trigger('canSave', false);
                }

            }, this);
        }
    },

    /**
     * @private
     * @type {String}
     */
    _dialogId: '',

    /**
     * Возвращает ID чата
     * @returns {String}
     */
    getDialog: function() {
        return this._dialogId;
    },

    /**
     * Метод подготовки формы. Должен быть вызван при каждом показе формы
     */
    prepareToShow: function() {
        // очищаем блок ошибок перед началом работы блока
        this.updateErrors();

        this._input.val('');

        this._canSave = false;
    },

    /**
     * Обновляет сообщение об ошибке
     * В зависимости от наличия текста снимается/выставляется модификатор _with-errors_no
     * @param {String|Array} [errorText] текст ошибки или массив с ошибками
     * @private
     */
    updateErrors: function(errorText) {
        errorText && (errorText = BEMHTML.apply({
            block: 'b-add-ya-dialog',
            elem: 'error',
            content: errorText
        }));

        BEM.DOM.update(this.elem('errors'), errorText || '');

        this.toggleMod('with-errors', 'no', !errorText);
        this._canSave = !errorText;
    },

    destruct: function() {
        this._input.un('change');
    }

}, {

    live: true

});
