block('b-additional-actions').elem('personal-info')(
    content()(function() {
        var person = this.ctx.person,
            // @belyanskii - По задаче DIRECT-64949, убрать когда будет приходить тип агенства
            isSelfAgency = person.email == 'agency-service@yandex-team.ru';

        return [
            {
                elem: 'title',
                elemMods: this.elemMods
            },
            {
                elem: 'name',
                content: isSelfAgency ?
                    {
                        block: 'link',
                        url: u.formatUrl({
                            protocol: 'https',
                            host: 'yandex.ru',
                            path: 'support/direct/troubleshooting/start.xml'
                        }),
                        content: iget2('b-additional-actions', 'otdel-po-rabote-s', 'Отдел по работе с рекламными агентствами')
                    } :
                    person.name
            },
            !isSelfAgency ? {
                block: 'link',
                mix: { block: 'b-additional-actions', elem: 'email' },
                url: 'mailto:' + person.email,
                content: person.email
            } : ''
        ];
    }),

    elem('title').elemMod('type', 'manager').content()(function() { return iget2('b-additional-actions', 'vash-menedzher', 'Ваш менеджер'); }),

    elem('title').elemMod('type', 'chief').content()(function() { return iget2('b-additional-actions', 'glavnyy-predstavitel', 'Главный представитель'); })
);
