block('b-additional-actions')(
    content()(function() {
        return [
            (this.ctx.groups || this.ctx.manager || this.ctx.chief) && {
                elem: 'wrap',
                content: [
                    {
                        elem: 'actions',
                        groups: this.ctx.groups,
                        inThreeColumns: this.ctx.inThreeColumns
                    },
                    {
                        elem: 'info',
                        manager: this.ctx.manager,
                        chief: this.ctx.chief
                    }
                ]
            },
            this.ctx.footnotes && this.ctx.footnotes.length && {
                block: 'b-additional-actions',
                elem: 'footnotes',
                elemMods: { 'with-top-offset': !(this.ctx.groups || this.ctx.manager || this.ctx.chief) ? 'yes' : '' },
                footnotes: this.ctx.footnotes
            }
        ]
    }),

    elem('actions').content()(function() {
        var groups = this.ctx.groups,
            groupsLength = this.ctx.inThreeColumns ?
                3 :
                (groups && groups.length == 2) ?
                    1 :
                    2,
            keys = u._.groupBy(groups, function(value, i) {
                return Math.floor(i / groupsLength);
            }),
            values = u._.values(keys);

        return values.map(function(groupContainer) {
            return {
                block: 'b-additional-actions',
                elem: 'action-group-wrapper',
                content: groupContainer.map(function(group) {
                    return {
                        block: 'b-additional-actions',
                        elem: 'action-group',
                        group: group
                    }
                })
            };
        });
    }),

    elem('info').content()(function() {
        return [
            this.ctx.manager && {
                block: 'b-additional-actions',
                elem: 'personal-info',
                elemMods: { type: 'manager' },
                person: this.ctx.manager
            },

            this.ctx.chief && {
                block: 'b-additional-actions',
                elem: 'personal-info',
                elemMods: { type: 'chief' },
                person: this.ctx.chief
            }
        ]
    }),

    elem('footnotes').content()(function() {
        return this.ctx.footnotes.map(function(footnote) {
            return footnote && {
                block: 'b-additional-actions',
                elem: 'footnote',
                content: [
                    {
                        elem: 'sup',
                        tag: 'span',
                        content: footnote.footnoteNo
                    },
                    footnote.text
                ]
            }
        })
    })
);
