BEM.DOM.decl({ block: 'b-adjustment-device-chooser', modName: 'multi', modVal: 'yes' }, {

    onSetMod: {
        js: function() {
            BEM.blocks['radiobox'].on(this.domElem, 'change', this._onControlsChange, this);
            BEM.blocks['checkbox'].on(this.domElem, 'change', this._onControlsChange, this);
            this.blockInside('add-button', 'button2').on('click', this._onAddButtonClick, this);

            this.__base.apply(this, arguments);
        }
    },

    _getRadioboxes: function() {
        return this._radioboxes || (this._radioboxes = this.findBlocksInside('radiobox'));
    },

    _getCheckboxes: function() {
        return this._checkboxes || (this._checkboxes = this.findBlocksInside('checkbox'));
    },

    _getValue: function() {
        var radioValue = this._getRadioboxes()
                .map(function(radio) {
                    return radio.val();
                })
                .filter(Boolean),
            checkValue = this._getCheckboxes()
                .filter(function(checkbox) {
                    return checkbox.hasMod('checked', 'yes');
                })
                .map(function(checkbox) {
                    return checkbox.name();
                });

        return [].concat(radioValue).concat(checkValue);
    },

    _onControlsChange: function() {
        this.afterCurrentEvent(function() {
            this._val = this._getValue();

            this._updateButtonText(this._val);
        });
    },

    _updateButtonText: function(value) {
        BEM.DOM.replace(
            this.findElem('add-button-content'),
            BEMHTML.apply({
                block: this.__self.getName(),
                elem: 'add-button-content',
                count: value.length
            })
        );
    },

    _onAddButtonClick: function() {
        this._applyValue(this._val || []);
    },

    _onMenuItemClick: function(e, data) {}

});
