block('b-adjustment-device-chooser')(

    replace()(function() {
        var options = this.ctx.options;

        return {
            block: 'popup2',
            mods: { target: 'anchor', theme: 'normal', autoclosable: 'yes' },
            mix: { block: this.block, mods: this.mods },
            directions: ['bottom-left', 'top-left'],
            zIndexGroupLevel: 6,
            content: {
                block: this.block,
                mods: this.mods,
                elem: 'content',
                options: options
            }
        }
    }),

    elem('content')(
        content()(function() {
            var options = this.ctx.options,
                isMobileCurrent = u._.includes(u['b-adjustment-device-chooser'].getMobileTypes(), options.current),
                isMobileChoosed = !!u._.intersection(
                    u['b-adjustment-device-chooser'].getMobileTypes(),
                    options.choosed
                ).length;

            return {
                block: 'menu',
                mods: { type: 'default', theme: 'normal', size: 'xs', width: 'max', tone: 'default' },
                items: [
                    {
                        title: u['b-adjustment-device-chooser'].getType('mobile'),
                        items: u['b-adjustment-device-chooser'].getMobileTypes().map(function(key) {
                            return {
                                text: u['b-adjustment-device-chooser'].getName(key),
                                val: key,
                                elemMods: u._.includes(options.choosed, key) || !isMobileCurrent && isMobileChoosed ?
                                    { disabled: 'yes' } :
                                    undefined
                            }
                        }, this)
                    },
                    {
                        title: u['b-adjustment-device-chooser'].getType('other'),
                        items: u['b-adjustment-device-chooser'].getOtherTypes().map(function(key) {
                            return {
                                text: u['b-adjustment-device-chooser'].getName(key),
                                val: key,
                                elemMods: u._.includes(options.choosed, key) ? { disabled: 'yes' } : undefined
                            }
                        }, this)
                    }
                ]
            };
        })
    ),

    elem('add-button-content').content()(function() {
        var count = this.ctx.count;

        return count ?
            iget2('b-adjustment-device-chooser', 'add-count', 'Добавить — {count}', { count: String(count) }) :
            iget2('b-adjustment-device-chooser', 'add', 'Добавить');
    })

);
