block('b-adjustment-rates-popup-chooser').def()(function() {
    var conditions = this.ctx.conditions,
        hasLimit = this.ctx.limit < conditions.accessibleCount;

    return applyCtx({
        block: 'popup',
        mods: {
            animate: 'no',
            adaptive: 'yes',
            'content-adaptive': 'yes'
        },
        mix: [{
            block: 'b-adjustment-rates-popup-chooser',
            mods: this.mods,
            js: {
                limit: this.ctx.limit,
                hasLimit: hasLimit
            }
        }],
        js: { directions: ['top-left', 'bottom-left'] },
        content: [
            {
                elem: 'content',
                content: [
                    {
                        block: 'b-chooser',
                        mods: {
                            multi: 'yes',
                            search: 'yes'
                        },
                        content: [
                            {
                                elem: 'search',
                                hint: u.pluralizeWord([
                                    iget2('b-adjustment-rates-popup-chooser', 'iskat-uslovie-vsego-s', 'Искать условие (всего {foo} условие)', {
                                        foo: conditions.accessibleCount
                                    }),
                                    iget2('b-adjustment-rates-popup-chooser', 'iskat-uslovie-vsego-s-102', 'Искать условие (всего {foo} условия)', {
                                        foo: conditions.accessibleCount
                                    }),
                                    iget2('b-adjustment-rates-popup-chooser', 'iskat-uslovie-vsego-s-103', 'Искать условие (всего {foo} условий)', {
                                        foo: conditions.accessibleCount
                                    })
                                ], conditions.accessibleCount)
                            },
                            {
                                elem: 'wrap',
                                js: { childrenCount: conditions.count },
                                content: [
                                    {
                                        block: 'b-adjustment-rates-popup-chooser',
                                        elem: 'mass-action-wrap',
                                        content: [
                                            {
                                                block: 'checkbox',
                                                mix: [{
                                                    block: 'b-adjustment-rates-popup-chooser',
                                                    elem: 'mass-action'
                                                }],
                                                text: iget2('b-adjustment-rates-popup-chooser', 'vse-usloviya-podbora-auditorii', 'Все условия подбора аудитории')
                                            },
                                            hasLimit && {
                                                block: 'b-adjustment-rates-popup-chooser',
                                                elem: 'help-text'
                                            }
                                        ]
                                    },
                                    conditions.all.map(function(condition) {
                                        var elemMods;

                                        if (this.ctx.selected.indexOf(condition.retargetingId) != -1) {
                                            elemMods = {
                                                selected: 'yes',
                                                disabled: 'yes'
                                            };
                                        }

                                        if (!condition.isAccessible && !elemMods) {
                                            elemMods = { disabled: 'yes' };
                                        }

                                        return {
                                            elem: 'item',
                                            js: {
                                                text: condition.name,
                                                condition: condition
                                            },
                                            elemMods: elemMods,
                                            mix: [{
                                                block: 'b-adjustment-rates-popup-chooser',
                                                elem: 'chooser-item',
                                                elemMods: { accessible: condition.isAccessible ? 'yes' : 'no' }
                                            }],
                                            name: condition.retargetingId,
                                            content: condition.name
                                        }
                                    }, this)
                                ]
                            },
                            { elem: 'not-found' }
                        ]
                    },
                    {
                        block: 'b-adjustment-rates-popup-chooser',
                        elem: 'buttons-wrap',
                        content: [
                            {
                                block: 'button',
                                mods: { disabled: 'yes' },
                                mix: [{
                                    block: 'b-adjustment-rates-popup-chooser',
                                    elem: 'add'
                                }],
                                content: [
                                    iget2('b-adjustment-rates-popup-chooser', 'sozdat-korrektirovok', 'Создать корректировок'),
                                    {
                                        block: 'b-adjustment-rates-popup-chooser',
                                        elem: 'add-counter',
                                        content: ' — 0'
                                    }
                                ]
                            },
                            {
                                block: 'button',
                                mods: { disabled: 'yes' },
                                mix: [{
                                    block: 'b-adjustment-rates-popup-chooser',
                                    elem: 'save'
                                }],
                                content: iget2('b-adjustment-rates-popup-chooser', 'sohranit-korrektirovku', 'Сохранить корректировку')
                            }
                        ]
                    }
                ]
            }
        ]
    });
});
