BEM.DOM.decl('b-adjustment-rates-popup-chooser', {

    onSetMod: {

        js: function() {
            this._limit = this.params.limit;

            this._popup = this.findBlockOn('popup')
                .on('hide', this._resetChooser, this);

            this._addButton = this.findBlockInside('add', 'button')
                .on('click', this._onAddClick, this);

            this._saveButton = this.findBlockInside('save', 'button')
                .on('click', this._onSaveClick, this);

            this._chooser = this.findBlockInside('b-chooser')
                .on('change', this._onChooserChange, this)
                .on('search.finish', function() {
                    this._updateGroupCheckbox();
                }, this);

            this._groupCheckbox = this.findBlockInside('mass-action', 'checkbox')
                .on('change', this._onGroupCheckboxChange, this);

            this._allCount = this._chooser.getAll().length;
        }

    },

    /**
     * Содержит массив выбранных условий за текущие открытие попапа
     * выбранные = все выбранные - созданные
     */
    _notConfirmed: null,

    /**
     * Возвращает true, если возможно создать условие(есть условия без модификатор disabled yes)
     * @returns {Boolean}
     */
    canAdd: function() {
        var index = 0,
            allItems = this._chooser.getAll();

        for (index; index < allItems.length; index++) {
            if (!allItems[index].disabled) {
                return true;
            }
        }

        return false;
    },

    /**
     * Триггерит событие add, запоминает выбранные условия
     * @private
     */
    _onAddClick: function() {
        var selected = this._chooser.getSelected();

        this._notConfirmed.forEach(function(item) {
            this._chooser.disable(item.name); // созданные условия становятся неактивными и скрываются
        }, this);

        this.trigger('add', {
            newItems: this._notConfirmed,
            isLimit: this._limit <= selected.length || this._allCount == selected.length
        });

        this._addButton.setMod('disabled', 'yes');

        // обнуление счётчика выбранных условий
        this.elem('add-counter')
            .text(' — 0');

        this._notConfirmed = null; // чтобы не снились при resetChooser
        this._confirmed = selected; // кэшируем выбранные для нахождения разницы в дальнейших сессиях созданий условий

        this._popup.hide();
    },

    /**
     * Находит элементы выбранные за текущее открытие попапа
     * @param {Array} confirmed - выбранные за предыдущие открытие
     * @param {Array} selected - все выбранные
     * @returns {Array}
     * @private
     */
    _xor: function(confirmed, selected) {
        var confirmedCount = confirmed.length;

        if (!confirmedCount) {
            return selected;
        }

        return selected.reduce(function(uniqItems, current) {
            var currentName = current.name,
                isUniq = true;

            for (var i = 0; i < confirmedCount; i++) {
                if (confirmed[i].name === currentName) {
                    isUniq = false;

                    break;
                }
            }

            isUniq && uniqItems.push(current);

            return uniqItems;
        }, []);
    },

    /**
     * Обработчик изменения b-chooser
     * @param {Event} e
     * @param {Object} data
     *  @param {String} data.name - id условия
     *  @param {Boolean} data.selected - выбран/не выбран
     *  @param {*} [data.extraParams] - дополнительные параметры
     * @private
     */
    _onChooserChange: function(e, data) {
        var type = this.getMod('type'),
            selected = this._chooser.getSelected(),
            notConfirmed,
            notConfirmedCount;

        if (type == 'add') {
            notConfirmed = this._xor(this._confirmed || [], selected); // выбранные = все выбранные - созданные
            notConfirmedCount = notConfirmed.length;

            // обновление счётчика выбранных условий
            this.elem('add-counter')
                .text(' — ' + notConfirmedCount);

            // если состояние блока b-chooser изменилось из-за группового checkbox,
            // то нет необходимости обновлять его статус группового checkbox
            data.extraParams.formGroupCheckbox || this._updateGroupCheckbox();
            this._notConfirmed = notConfirmed;
        }

        if (type == 'editing') {
            var currentName = data.name;

            if (data.selected && this._newOwnerName != currentName) {
                var uncheckName = this._newOwnerName;

                // skywhale:
                // последовательность важна, т.к. b-chooser триггерит два раза событие 'change'
                this._newOwnerName = currentName;
                this._chooser.uncheck(uncheckName); // после uncheck будет 'change'

            } else if (this._newOwnerName == currentName) {
                this._chooser.check(currentName);
            }

            this._prevOwnerName == currentName ?
                this._saveButton.setMod('disabled', 'yes') :
                this._saveButton.delMod('disabled');
        }

        notConfirmedCount && (selected.length <= this._limit) ?
            this._addButton.delMod('disabled') :
            this._addButton.setMod('disabled', 'yes');
    },

    /**
      * Выставляет групповому checkbox правильное состояние
      * @param {Boolean} onlyText - флаг, если true обновит только поясняющий текст под checkbox
      * @returns {BEM}
      * @private
      */
    _updateGroupCheckbox: function(onlyText) {
        var canAdd = this._limit,
            available = 0, // доступные для выбора
            currentSelected = 0,
            allSelected = 0,
            visible = 0,
            itemsToAdd = 0,
            helpText;

        this._chooser.getAll().forEach(function(item) {
            if (!item.hidden && !item.disabled) {
                item.selected ?
                    currentSelected++ :
                    available++;
            }

            if (item.selected) {
                canAdd && canAdd--;
                allSelected++;
            }

            !item.hidden && visible++;
        });

        if (!onlyText) {
            available ?
                currentSelected ?
                    this._groupCheckbox
                        .setMod('indeterminate', 'yes') :
                    this._groupCheckbox
                        .delMod('indeterminate')
                        .delMod('checked') :
                currentSelected ?
                    this._groupCheckbox.
                        setMod('checked', 'yes') :
                    this._groupCheckbox
                        .delMod('indeterminate')
                        .delMod('checked');
        }

        // обновляем подсказку,
        // если общее количество условий клиента превышает указанный лимит
        if (this.params.hasLimit) {
            // количество условий, которые будут выбраны с помощью группового checkbox
            itemsToAdd = canAdd > available ? available : canAdd;

            if (allSelected == this._limit) {
                helpText = iget2('b-adjustment-rates-popup-chooser', 'vybrano-maksimalnoe-kolichestvo-usloviy', 'Выбрано максимальное количество условий');
            } else if (allSelected < this._limit && itemsToAdd) {
                helpText = u.pluralizeWord([
                    iget2('b-adjustment-rates-popup-chooser', 'budet-vybrano-s-uslovie', 'Будет выбрано {foo} условие', {
                        foo: itemsToAdd
                    }),
                    iget2('b-adjustment-rates-popup-chooser', 'budut-vybrany-pervye-s', 'Будут выбраны первые {foo} условия', {
                        foo: itemsToAdd
                    }),
                    iget2('b-adjustment-rates-popup-chooser', 'budut-vybrany-pervye-s-104', 'Будут выбраны первые {foo} условий', {
                        foo: itemsToAdd
                    })
                ], itemsToAdd);
            } else if (allSelected < this._limit && !itemsToAdd) {
                helpText = ''
            } else {
                helpText = iget2('b-adjustment-rates-popup-chooser', 'nelzya-sozdat-bolshe-100', 'Нельзя создать больше 100 условий');
            }

            this.elem('help-text').text(helpText);
        }

        return this;
    },

    /**
     * Сбрасывает выбранные условия
     * @returns {BEM}
     * @private
     */
    _resetChooser: function(e, data) {
        var type = this.getMod('type');

        if (type == 'add' && this._notConfirmed) {
            this._chooser
                .uncheck(u._.pluck(this._notConfirmed, 'name'));
        }

        if (type == 'editing') {
            this._chooser
                .enable(this._newOwnerName)
                .uncheck(this._newOwnerName);

            this._chooser
                .disable(this._prevOwnerName)
                .check(this._prevOwnerName);
        }

        this.delMod('type');
        this._chooser.search('');

        return this;
    },

    /**
     * Обработчик изменения группового checkbox
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onGroupCheckboxChange: function(e, data) {
        if (data.checked) {
            var allSelected = this._chooser.getSelected().length;

            this._chooser
                .getAll().forEach(function(item) {
                    var isAvailable = !(item.selected || item.disabled || item.hidden),
                        isLimit = allSelected < this._limit;

                    if (isLimit && isAvailable) {
                        allSelected = allSelected + 1;

                        this._chooser
                            .check(item.name, { formGroupCheckbox: true });
                    }
                }, this);

            this._updateGroupCheckbox(allSelected >= this._limit);
        } else {
            if (!this._groupCheckbox.hasMod('indeterminate')) {
                this._chooser
                    .getAll().forEach(function(item) {
                        if (item.selected && !item.disabled && !item.hidden) {
                            this._chooser.uncheck(item.name, { formGroupCheckbox: true });
                        }
                    }, this);
            }

            this._updateGroupCheckbox(true);
        }
    },

    /**
     * Cохраняет условие
     * @private
     */
    _onSaveClick: function() {
        this.trigger('save', {
            prevName: this._prevOwnerName,
            newName: this._newOwnerName
        });

        // необходимо для правильной работы метода _resetChooser
        this._prevOwnerName = this._newOwnerName;

        this._popup.hide();
    },

    enable: function(name) {
        this._chooser.enable(name);

        return this;
    },

    uncheck: function(name) {
        this._chooser.uncheck(name);

        return this;
    },

    disable: function(name) {
        this._chooser.disable(name);

        return this;
    },

    check: function(name) {
        this._chooser.check(name);

        return this;
    },

    getPopup: function() {
        return this._popup;
    },

    getChooser: function() {
        return this._chooser;
    },

    _ownerName: null,

    _prevOwnerName: null,

    /**
     * Открывает/скрывает попап
     * @param {jQuery} owner
     * @param {String} ownerName
     * @returns {toggle}
     */
    toggle: function(owner, ownerName) {
        this._popup
            .toggle(owner);

        this._confirmed = this._chooser.getSelected();

        if (this._popup.isShown()) {
            var visibleCount = 0;

            this._updateGroupCheckbox();

            this._chooser.getAll().forEach(function(item) {
                if (!item.disabled && !item.selected) {
                    visibleCount++;
                }
            });

            visibleCount >= 10 ?
                this.delMod('search') :
                this.setMod('search', 'hidden');

            if (ownerName) {
                this._chooser
                    .enable(ownerName);

                // скрываем кнопку «Сохранить корректировку», если нет доступных для выбора элементов
                visibleCount ?
                    this.delMod('buttons-wrap') :
                    this.setMod('buttons-wrap', 'hidden');

                this._prevOwnerName = this._newOwnerName = ownerName;
            } else {
                this.delMod('buttons-wrap');
            }
        }

        return this;
    }

}, {

});
