block('b-adjustment-rates-popup').elem('popup').replace()(function() {
    var ctx = this.ctx,
        tabsContent = [],
        panesContent = [],
        tabs = Object.keys(ctx.tabs).sort(function(a, b) {
            return ctx.tabs[a].index > ctx.tabs[b].index;
        });

    tabs.forEach(function(tab) {
        tabsContent.push({
            elem: 'tab',
            content: {
                block: 'link',
                content: ctx.tabs[tab].title
            }
        });

        panesContent.push({
            elem: 'pane',
            content: {
                block: 'b-adjustment-rates',
                mods: {
                    type: tab,
                    layout: ctx.withSign ? 'with-sign' : 'normal'
                },
                js: {
                    modelId: ctx.modelId
                },
                modelId: ctx.modelId,
                modelData: ctx.modelData[tab]
            }
        });
    });

    return {
        block: 'popup',
        js: { directions: 'right' },
        mods: {
            'has-close': 'yes',
            adaptive: 'no',
            'child-state': 'yes',
            autoclosable: 'no',
            type: this.ctx.modal ? 'modal' : '',
            position: this.ctx.modal ? 'fixed' : '',
            'body-scroll': this.ctx.modal ? 'no' : ''
        },
        underMods: { type: this.ctx.modal ? 'paranja' : '' },
        mix: [{
            block: 'b-adjustment-rates-popup',
            elem: 'popup'
        }],
        content: [
            !this.ctx.modal && { elem: 'tail' },
            {
                elem: 'content',
                mix: {
                    block: 'b-adjustment-rates-popup',
                    elem: 'popup-content'
                },
                content: [
                    {
                        block: 'b-adjustment-rates-popup',
                        elem: 'title',
                        content: iget2('b-adjustment-rates-popup', 'korrektirovki-stavok', 'Корректировки ставок')
                    },
                    {
                        block: 'tabs',
                        mods: {
                            control: 'menu',
                            size: 's',
                            theme: 'normal-red',
                            layout: 'horiz'
                        },
                        panes: 'tabs-' + ctx.modelId,
                        content: tabsContent
                    },
                    {
                        block: 'tabs-panes',
                        id: 'tabs-' + ctx.modelId,
                        content: panesContent
                    },
                    {
                        block: 'b-adjustment-rates-popup',
                        elem: 'actions'
                    }
                ]
            }
        ]
    };
});
