/**
 *
 * @event b-adjustment-rates-popup#popup-show открытие popup
 * @event b-adjustment-rates-popup#save-click клик по кнопке сохранить
 *
 * @fires b-adjustment-rates-popup#popup-show
 * @fires b-adjustment-rates-popup#save-click
 *
 */
BEM.DOM.decl('b-adjustment-rates-popup', {

    /**
     * Переводы и index табов
     * {Object}
     */
    _vTabs: null,

    /**
     * Массив сортированных по index табов (this._vTabs)
     * {Array}
     */
    _sortedTabs: null,

    /**
     * Табы
     * {BEM}
     * @private
     */
    _tabs: null,

    /**
     * Popup
     * {BEM}
     * @private
     */
    _popup: null,

    onSetMod: {
        js: function() {
            this._subscriptionManager = BEM.create('i-subscription-manager');
            this._model = BEM.MODEL.getOrCreate({ name: 'm-adjustment-rates', id: this.params.modelId });

            this._vTabs = this.params.tabs;
            this._defaultTabName = this.params.defaultTab || this._getAvailableTabsNames()[0];

            this._fillDataInput();

            this._subscriptionManager
                .wrap(BEM.blocks['i-resize'].getInstance())
                .on('start end', function() {
                    this._getPopup().isShown() && this._getPopup().repaint();
                }, this);
        }
    },

    /**
     * Удаляет блок и подписки i-subscription-manager
     * @override
     */
    destruct: function() {
        // отменяем не сохраненные изменения
        if (this._model.isChanged()) {
            this._model.rollback();
        }

        this._subscriptionManager.dispose();
        this._subscriptionManager.destruct();

        if (this._popup && this._popup.domElem) {
            BEM.DOM.destruct(this._popup.domElem);
        }

        this.__base.apply(this, arguments);
    },

    /**
     * Открывает попап
     * @param {jQuery} switcher
     * @private
     */
    _showPopup: function(switcher) {
        this._tabs && this._tabs.activate(this._getIndexOpenTab());

        var isModal = this.params.modal,
            popup = this._getPopup();

        if (isModal) {
            this._subscriptionManager.on(popup, 'show hide', this._onModalShowHide, this);
        }

        popup.toggle(isModal ? undefined : switcher);
    },

    /**
     * Заполняет данными скрытый инпут для страницы «Параметры кампании»
     * @returns {BEM}
     * @private
     */
    _fillDataInput: function() {
        if (this.elem('hidden-input').length) {
            this.elem('hidden-input').val(JSON.stringify(this._model.provideData()));
        }

        return this;
    },

    /**
     * Создаёт и возвращает popup
     * @returns {BEM}
     * @private
     */
    _getPopup: function() {
        if (!this._popup) {
            var modelData = this._model.toJSON();

            BEM.DOM.append(this.domElem, BEMHTML.apply({
                block: 'b-adjustment-rates-popup',
                elem: 'popup',
                modelId: this.params.modelId,
                tabs: this._vTabs,
                modelData: modelData,
                withSign: modelData.demography.canChangeSign,
                modal: this.params.modal
            }));

            this._popup = this.findBlockInside('popup', 'popup');
            this._subscriptionManager.wrap(this._popup)
                .on('hide', function() {
                    // Выполняем действия после закрытия попапа
                    // + проверяем на isChanged
                    this.afterCurrentEvent(
                        function() {
                            if (this._model.isChanged()) {
                                this._needSave ? this._model.fix() : this._model.rollback();
                            }

                            this._needSave = false;
                        }, this);
                }, this)
                .on('show', function() {
                    this.trigger('popup-show');
                }, this);

            this._tabs = this.findBlockInside('tabs');

            this._subscriptionManager.on(
                this._tabs,
                'change',
                function(e, indexInfo) {
                    this._getTabByIndex(indexInfo.currentIndex);
                },
                this
            );

            this._tabs.activate(this._getIndexOpenTab());

            this._subscriptionManager.wrap(this.findBlockInside('apply', 'button'))
                .on('click', this._onApplyClick, this);

            this._subscriptionManager.wrap(this.findBlockInside('decline', 'button'))
                .on('click', this._onDeclineClick, this);
        }

        return this._popup;
    },

    /**
     * Обработчик события click по кнопке «Сохранить»
     * @private
     */
    _onApplyClick: function() {
        this.trigger('save-click');
        if (this._model.isValid()) {

            this._model.fix();

            this._popup.hide();

            this
                ._renderText()
                ._fillDataInput(); //Для страницы параметров Кампании

            this.trigger('save');
        } else {
            var tabs = this._vTabs,
                tabsKeys = u._.keys(this._model.validate().errorsData),
                tabsText = tabsKeys.map(function(key) { return tabs[key]['title'] }).join(', ');

            BEM.blocks['b-confirm']
                .alert(iget2('b-adjustment-rates-popup', 'ispravte-oshibki-v-sleduyushchih', 'Исправьте ошибки в следующих табах: {foo}.', {
                    foo: tabsText
                }),this._getPopup());
        }
    },

    /**
     * Обработчик события click по кнопке «Отмена»
     * @private
     */
    _onDeclineClick: function() {
        var popup = this._popup;

        this._model.isChanged() ?
            BEM.blocks['b-confirm'].open({
                textYes: iget2('b-adjustment-rates-popup', 'da', 'Да'),
                textNo: iget2('b-adjustment-rates-popup', 'net', 'Нет'),
                message: iget2('b-adjustment-rates-popup', 'izmeneniya-ne-budut-sohraneny', 'Изменения не будут сохранены. Продолжить?'),
                onNo: function() { },
                onYes: function() {
                    this._needSave = false;
                    popup.hide();
                }
            }, this) :
            popup.hide();
    },

    /**
     * Возвращает блок для таба по index
     * @param {Number} index
     * @returns {BEM}
     * @private
     */
    _getTabByIndex: function(index) {
        var tabName = this._getAvailableTabsNames()[index];

        if (!this._sortedTabs) this._sortedTabs = {};

        typeof (tabName) == 'string' &&
            (this._sortedTabs[index] = this.findBlockInside(this._getPopup().domElem,
                { block: 'b-adjustment-rates', modName: 'type', modVal: tabName }));

        // this._sortedTabs = [{ block: 'b-adjustment-rates', modName: 'type', modVal: 'retargeting' }, ...]

        return this._sortedTabs[index];
    },

    /**
     * Возвращает имена доступных табов в виде массива
     * @returns {Array}
     * @private
     */
    _getAvailableTabsNames: function() {
        if (!this._tabsNames) {
            var tabs = this._vTabs;

            this._tabsNames = Object.keys(tabs).sort(function(a, b) {
                return tabs[a].index > tabs[b].index;
            });
        }

        return this._tabsNames;
    },

    /**
     * Вернет index таба,
     * на котором нужно открыть попап
     * @returns {Number} index
     */
    _getIndexOpenTab: function() {
        var tabs = this._vTabs,
            selected = this._getSelectedTabs();

        if (selected.length) return tabs[selected[0]].index;

        return tabs[this._defaultTabName].index;
    },

    /**
     * Возвращает табы, которые были выбраны
     * @returns {Array} ['retargeting', 'mobile']
     */
    _getSelectedTabs: function() {
        var vModel = this._model;

        return Object.keys(this._vTabs).reduce(function(res, field) {
            vModel.get(field) && vModel.get(field).get('isEnabled') &&
                (field === 'mobile' ||
                    field === 'video' ||
                    field === 'performance-tgo' ||
                    !!vModel.get(field).get('rates').length()) && res.push(field);

            return res;
        }, []);
    },

    /**
     * Обновляет текст под кнопкой «изменить»
     * @returns {BEM}
     * @private
     */
    _renderText: function() {
        BEM.DOM.update(this.elem('rates'), BEMHTML.apply({
            block: this.__self.getName(),
            elem: 'rates-text',
            modelData: this._model.toJSON()
        }, this));

        return this;
    },

    /**
     * Обработчик показа/скрытия попапа корректировок, когда он показывается в модальном окне
     * @param {jQuery.Event} e
     * @private
     */
    _onModalShowHide: function(e) {
        // `resize-watcher` заводить можно только тогда когда попап гарантировано показан
        this.afterCurrentEvent(function() {
            var popup = e.block;

            if (this._resizeWatcher) {
                this._resizeWatcher.destruct();
                this._resizeWatcher = null;
            }

            if (e.type === 'show') {
                this._resizeWatcher = BEM.blocks['resize-watcher'].getInstance({
                    owner: this.findElem(popup.domElem, 'popup-content'),
                    ignoreWidth: true,
                    timeout: 100
                });

                this._subscriptionManager.on(
                    this._resizeWatcher,
                    'change',
                    function() {
                        if (popup.isShown()) {
                            var popupCurrPos = popup.getCurrPos(),
                                popupSize = popup.getPopupSize(),
                                viewPortSize = popup._getSizeOf(popup._viewport);

                            // Если в процессе изменения высоты блока корректировок ушли за нижнюю границу вьюпорта -
                            // то вызываем `repaint` у попапа
                            if (popupCurrPos.marginTop + popupSize.height > viewPortSize.height / 2) {
                                popup.repaint();
                            }
                        }
                    },
                    this
                );
            }
        })
    },

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'button', function(e) {
            this._showPopup(e.block.domElem);
        });
    }
});
