u.register({
    'b-adjustment-rates-popup': {
        /**
         * Возвращает имя для таба по его id
         * @param {[mobile|video|demography|retargeting|performance-tgo]} id
         * @returns {String}
         */
        getTabTitleById: function(id) {
            switch (id) {
                case 'demography':
                    return iget2('b-adjustment-rates-popup', 'pol-i-vozrast', 'Пол и возраст');
                case 'retargeting':
                    return iget2('b-adjustment-rates-popup', 'celevaya-auditoriya', 'Целевая аудитория');
                case 'mobile':
                    return iget2('b-adjustment-rates-popup', 'mobilnye', 'Мобильные');
                case 'video':
                    return iget2('b-adjustment-rates-popup', 'video', 'Видео');
                case 'performance-tgo':
                    return iget2('b-adjustment-rates-popup', 'performance-tgo', 'Смарт-объявления');
                case 'devices':
                    return iget2('b-adjustment-rates-popup', 'devices', 'Устройства');
                case 'cpm-group-type':
                    return iget2('b-adjustment-rates-popup', 'cpm-group-type', 'Инвентарь');
                case 'weather':
                    return iget2('b-adjustment-rates-popup', 'weather', 'Погода');
                case 'traffic-jam':
                    return iget2('b-adjustment-rates-popup', 'traffic-jam', 'Пробки');
            }
        },

        /**
         * Возвращает объект с доступными табами и их свойствами
         * @param {Object} options
         * @param {Boolean} options.demography
         * @param {Boolean} options.mobile
         * @param {Boolean} options.video
         * @param {Boolean} options.retargeting
         * @param {Boolean} options.performanceTGO
         * @param {Boolean} options.hasRetargetingConditions - у пользователя есть созданные условия ретаргетинга
         * @param {Boolean} options.devices
         * @param {Boolean} options.cpmGroupType
         * @param {Boolean} options.weather
         * @param {Boolean} options.trafficJam
         * @returns {Object}
         */
        getTabsHash: function(options) {
            var tabsArray = [],
                tabsHash = {
                    tabs: {},
                    default: ''
                };

            //@heliarian порядок в массиве tabsArray важен - он определяет, какое условие будет выбрано по умолчанию
            options.retargeting && tabsArray.push('retargeting');

            if (options.devices) {
                tabsArray.push('devices');
            } else if (options.mobile) {
                tabsArray.push('mobile');
            }

            options.demography && tabsArray.push('demography');
            options.video && tabsArray.push('video');
            options.performanceTGO && tabsArray.push('performance-tgo');
            options.cpmGroupType && tabsArray.push('cpm-group-type');
            options.weather && tabsArray.push('weather');
            options.trafficJam && tabsArray.push('traffic-jam');

            tabsArray.forEach(function(name) {
                tabsHash.tabs[name] = {
                    title: this.getTabTitleById(name),
                    index: tabsArray.indexOf(name)
                }
            }, this);

            tabsHash['default'] =
                options.hasRetargetingConditions && options.retargeting ?
                    'retargeting' :
                        options.devices ?
                            'devices' :
                            options.mobile ?
                                'mobile' :
                                options.demography ?
                                    'demography' :
                                        options.cpmGroupType ?
                                            'cpm-group-type' :
                                            options.weather ?
                                                'weather' :
                                                options.trafficJam ?
                                                    'traffic-jam' :
                                                    'video';

            return tabsHash;
        }
    }
});
