block('b-adjustment-rates-view-only').elem('cpm-group-type').content()(function() {
    var cpmGroupTypeHelper = u['b-rates-chooser'].cpmGroupType,
        rates = this.ctx.data.rates,
        gruopedRates = u._.pick(
            u._.groupBy(rates, function(rate) {
                return cpmGroupTypeHelper.getGroupIdByRateType(rate.type);
            }),
            cpmGroupTypeHelper.getGroupIds()
        );

    return [
        {
            elem: 'list-head',
            content: iget2('b-adjustment-rates-view-only', 'inventory-type', 'Инвентарь') + ':'
        },
        u._.size(gruopedRates) ?
            {
                elem: 'list',
                content: u._.map(gruopedRates, function(rates, groupId) {
                    return {
                        elem: 'list-item',
                        content: [
                            cpmGroupTypeHelper.getText(groupId),
                            {
                                elem: 'list',
                                content: rates.map(function(rate) {
                                    var rateText = cpmGroupTypeHelper.getText(rate.type);

                                    return {
                                        elem: 'list-item',
                                        content: rate.sign === 'increment' ?
                                            iget2(
                                                'b-adjustment-rates-view-only',
                                                'increase-cpm-group-type-rate',
                                                '«{rateText}» увеличить на {count}%',
                                                {
                                                    rateText: rateText,
                                                    count: rate.input
                                                }
                                            ) :
                                            iget2(
                                                'b-adjustment-rates-view-only',
                                                'decrease-cpm-group-type-rate',
                                                '«{rateText}» уменьшить на {count}%',
                                                {
                                                    rateText: rateText,
                                                    count: rate.input
                                                }
                                            )
                                    }
                                })
                            }
                        ]
                    }
                })
            } :
            { elem: 'empty' }
    ];
});
