block('b-adjustment-rates-view-only').elem('devices').content()(function() {
    var rates = this.ctx.data.rates,
        gruopedRates = u._.groupBy(rates, function(rate) {
            return u._.includes(u['b-adjustment-device-chooser'].getMobileTypes(), rate.device) ?
                'mobile' :
                'other';
        });

    return [
        {
            elem: 'list-head',
            content: iget2('b-adjustment-rates-view-only', 'devices', 'Устройства') + ':'
        },
        u._.size(gruopedRates) ?
            {
                elem: 'list',
                content: u._.map(gruopedRates, function(rates, type) {
                    return {
                        elem: 'list-item',
                        content: [
                            u['b-adjustment-device-chooser'].getType(type),
                            {
                                elem: 'list',
                                content: rates.map(function(rate) {
                                    var deviceName = u['b-adjustment-device-chooser'].getName(rate.device);

                                    return {
                                        elem: 'list-item',
                                        content: rate.sign === 'increment' ?
                                            iget2(
                                                'b-adjustment-rates-view-only',
                                                'increase-device-rate',
                                                '«{deviceName}» увеличить на {count}%',
                                                {
                                                    deviceName: deviceName,
                                                    count: rate.input
                                                }
                                            ) :
                                            iget2(
                                                'b-adjustment-rates-view-only',
                                                'decrease-device-rate',
                                                '«{deviceName}» уменьшить на {count}%',
                                                {
                                                    deviceName: deviceName,
                                                    count: rate.input
                                                }
                                            )
                                    }
                                })
                            }
                        ]
                    }
                })
            } :
            { elem: 'empty' }
    ];
});
