block('b-adjustment-rates-view-only')(

    def()(function() {
        var data = this.data,
            campaign = data.campaign,
            isCPMCampaign = u._.includes(['cpm_banner', 'cpm_deals'], campaign.mediaType),
            isDevicesEnabled = isCPMCampaign ||
                (hasEnabledFeatures('cpc_device_modifiers') || u.consts('isMobileOsBidModifierEnabled')) &&
                    u._.includes(['text', 'dynamic', 'performance', 'content_promotion'], campaign.mediaType);

        u['i-adjustment-rates-data'].patchMultipliers(campaign, {
            multipliers_meta: u._.get(campaign, 'multipliers_meta') || u._.get(data, 'multipliers_meta'),
            isDevicesEnabled: isDevicesEnabled,
            isWithoutDeviceRestrictions: isCPMCampaign || hasEnabledFeatures('cpc_device_modifiers')
        });

        return applyNext({
            isDevicesEnabled: isDevicesEnabled
        });
    }),

    content()(function() {
        var campaign = this.data.campaign,
            hierarchicalMultipliers = campaign.hierarchicalMultipliers,
            result = [];

        result.push({
            elem: 'retargeting',
            data: hierarchicalMultipliers.retargeting
        });

        if (this.isDevicesEnabled) {
            result.push({
                elem: 'devices',
                data: hierarchicalMultipliers.devices
            });
        } else if (campaign.mediaType !== 'mobile_content' && campaign.mediaType !== 'mcbanner') {
            result.push({
                elem: 'mobile',
                data: hierarchicalMultipliers.mobile
            });
        }

        result.push({
            elem: 'demography',
            data: hierarchicalMultipliers.demography
        });

        if (campaign.mediaType === 'text') {
            result.push({
                elem: 'video',
                data: hierarchicalMultipliers.video
            });
        }

        if (campaign.mediaType === 'performance') {
            result.push({
                elem: 'performance-tgo',
                data: hierarchicalMultipliers['performance-tgo']
            });
        }

        if (campaign.mediaType === 'cpm_banner') {
            result.push({
                elem: 'cpm-group-type',
                data: hierarchicalMultipliers['cpm-group-type']
            });
        }

        return result;
    })
);
