block('b-adjustment-rates').elem('control').elemMod('type', 'age').content()(function() {
    var UNKNOWN_AGE_VALUE = 'unknown',
        isUnknownAgeEnabled = u.consts('isFeatureDemographyBidModifierUnknownAgeAllowed') ||
            this.ctx.value === UNKNOWN_AGE_VALUE;

    return {
        block: 'select',
        name: 'age',
        js: { elemPopupMods: { 'hide-first-option': 'yes' } },
        mix: [
            {
                block: 'b-adjustment-rates',
                elem: 'select'
            },
            {
                block: 'i-glue',
                elem: 'model-field',
                js: {
                    name: 'age',
                    type: 'select'
                }
            }
        ],
        content: [
            {
                block: 'button',
                content: iget2('b-adjustment-rates', 'vozrast', 'Возраст')
            },
            {
                elem: 'control',
                content: [
                    {
                        val: '',
                        text: iget2('b-adjustment-rates', 'vozrast', 'Возраст')
                    },
                    {
                        val: 'all',
                        disabled: this.ctx.isAllAgeDisabled ? true : undefined,
                        text: iget2('b-adjustment-rates', 'lyuboy', 'Любой')
                    },
                    {

                        val: '0-17',
                        text: iget2('b-adjustment-rates', 'mladshe-18', 'Младше 18')
                    },
                    {

                        val: '18-24',
                        text: '18-24'
                    },
                    {

                        val: '25-34',
                        text: '25-34'
                    },
                    {

                        val: '35-44',
                        text: '35-44'
                    },
                    {

                        val: '45-54',
                        text: '45-54'
                    },
                    {
                        val: '55-',
                        text: iget2('b-adjustment-rates', 'starshe-55', 'Старше 55')
                    },
                    isUnknownAgeEnabled && {
                        val: UNKNOWN_AGE_VALUE,
                        text: iget2('b-adjustment-rates', 'unknown', 'Неизвестный')
                    },
                ].filter(Boolean).map(function(item) {
                    return {
                        elem: 'option',
                        attrs: {
                            value: item.val,
                            selected: this.ctx.value === item.val ? true : undefined,
                            disabled: item.disabled
                        },
                        content: item.text
                    };
                }, this)
            }
        ]
    };
});
