 /**
  * Инпут для изменения ставки в корректировке
  * @param {String} ctx.value текущее значение ставки
  * @param {String} ctx.max максимально возможное значение ставки
  */
block('b-adjustment-rates').elem('control').elemMod('type', 'input').content()(function() {
    return [
        {
            block: 'input',
            mods: {
                size: this.ctx.size,
                clear: 'no',
                disabled: this.ctx.disabled ? 'yes' : ''
            },
            mix: [
                {
                    block: 'b-adjustment-rates',
                    elem: 'input'
                },
                {
                    block: 'i-glue',
                    elem: 'model-field',
                    js: {
                        name: 'input',
                        type: 'input'
                    }
                }
            ],
            value: this.ctx.value,
            placeholder: this.ctx.max ? iget2('b-adjustment-rates', 'max-s', 'max {foo}', {
                foo: this.ctx.max
            }) : '',
            content: [
                {
                    elem: 'control',
                    mix: {
                        block: 'i-glue',
                        elem: 'model-field',
                        js: {
                            type: 'attribute',
                            name: 'inputHint',
                            attributeName: 'placeholder'
                        }
                    }
                }
            ]
        }
    ];
});
