/**
 * Инпут для изменения знака ставки в корректировке
 * @param {String['increment'|'decrement']} ctx.value текущее значение знака ставки
 * @param {String} ctx.width значение модификатора width для селекта
 * @param {Boolean} ctx.withEmptyOption добавить в селект пустое значение
 */
block('b-adjustment-rates').elem('control').elemMod('type', 'sign').content()(function() {
    return [
        {
            block: 'select',
            mods: {
                width: this.ctx.width,
                disabled: this.ctx.disabled ? 'yes' : ''
            },
            mix: [
                //@heliarian -  микс нуже для b-adjustment-rates_type_mobile
                {
                    block: 'b-adjustment-rates',
                    elem: 'select',
                    elemMods: { action: 'operation' }
                },
                {
                    block: 'b-adjustment-rates',
                    elem: 'sign'
                },
                {
                    block: 'i-glue',
                    elem: 'model-field',
                    js: {
                        name: 'sign',
                        type: 'select'
                    }
                }
            ],
            content: [
                {
                    block: 'button',
                    content: iget2('b-adjustment-rates', 'uvelichit', 'увеличить')
                },
                {
                    elem: 'control',
                    content: [
                        this.ctx.withEmptyOption && {
                            value: '',
                            text: '&mdash;'
                        },
                        {
                            value: 'increment',
                            text: iget2('b-adjustment-rates', 'uvelichit', 'увеличить')
                        },
                        {
                            value: 'decrement',
                            text: iget2('b-adjustment-rates', 'umenshit', 'уменьшить')
                        }
                    ].map(function(item) {
                        return item && {
                            elem: 'option',
                            attrs: {
                                value: item.value,
                                selected: this.ctx.value == item.value ? 'selected' : undefined
                            },
                            content: item.text
                        };
                    }, this)
                }
            ]
        }
    ];
});
