block('b-adjustment-rates').elem('list-item').elemMod('type', 'cpm-group-type')(

    js()(function() {
        return { modelId: this.ctx.modelId };
    }),

    mix()(function() {
        var ctx = this.ctx;

        return {
            block: 'i-glue',
            js: {
                modelName: 'm-adjustment-cpm-group-type-rate',
                modelId: ctx.modelId
            }
        }
    }),

    content()(function() {
        var rate = this.ctx.rate;

        return [
            {
                elem: 'cell',
                content: [
                    {
                        block: 'button',
                        mods: { arrow: 'down' },
                        mix: [{
                            block: 'b-adjustment-rates',
                            elem: 'button',
                            elemMods: { action: 'toggle-type' }
                        }],
                        js: { 'rate-id': this.ctx.modelId },
                        content: {
                            block: 'i-glue',
                            elem: 'model-field',
                            js: { name: 'textType', type: 'inline' },
                            content: rate.textType
                        }
                    }
                ]
            },
            {
                elem: 'cell',
                content: [
                    {
                        elem: 'control',
                        elemMods: { type: 'sign' },
                        width: '9em',
                        value: rate.sign
                    },
                    {
                        elem: 'control',
                        elemMods: { type: 'input' },
                        value: rate.input,
                        max: rate.max
                    },
                    {
                        elem: 'warning-text',
                        content: iget2(
                            'b-adjustment-rates',
                            'shows-for-these-types-of-inventory-are-excluded',
                            'Показы на этом типе инвентаря исключены'
                        )
                    },
                    { elem: 'remove-rate' },
                    { elem: 'error-text' }
                ]
            }
        ];
    })
);
