/**
 * Отдельная корректировка ставок типа "демография"
 * @param {String} modelId
 * @param {Object} rate
 * @param {('increment'|'decrement')} rate.sign знак корректировки
 * @param {('male'|'female'|'all')} rate.gender пол
 * @param {String} rate.age возрастной промежуток
 * @param {Number} rate.input значение корректировки
 * @param {Number} rate.max максимальное доступное значение корректировки
 * @param {Boolean} [canChangeSign] можно ли менять знак корректировки
 * @param {Boolean} [isAllGenderDisabled] опция "Все" в контроле выбора пола задизейблена
 * @param {Boolean} [isAllAgeDisabled] опция "Любой" в контроле выбора возраста задизейблена
 *
 */
block('b-adjustment-rates').elem('list-item').elemMod('type', 'demography')(

    js()(function() {
        return { modelId: this.ctx.modelId };
    }),

    mix()(function() {
        return [{
            block: 'i-glue',
            js: {
                modelName: 'm-adjustment-demography-rate',
                modelId: this.ctx.modelId
            }
        }];
    }),

    content()(function() {
        var rate = this.ctx.rate;

        return [
            {
                elem: 'cell',
                content: [
                    {
                        elem: 'control',
                        elemMods: { type: 'gender' },
                        value: rate.gender,
                        isAllGenderDisabled: this.ctx.isAllGenderDisabled
                    },
                    {
                        elem: 'control',
                        elemMods: { type: 'age' },
                        value: rate.age,
                        isAllAgeDisabled: this.ctx.isAllAgeDisabled
                    }
                ]
            },
            {
                elem: 'cell',
                content: [
                    this.ctx.canChangeSign ?
                        {
                            elem: 'control',
                            elemMods: { type: 'sign' },
                            width: '9em',
                            value: rate.sign
                        } :
                        '',
                    {
                        elem: 'control',
                        elemMods: { type: 'input' },
                        value: rate.input,
                        max: rate.max
                    },
                    this.ctx.canChangeSign ?
                        {
                            elem: 'warning-text',
                            content: iget2('b-adjustment-rates', 'pokazy-dlya-dannoy-auditorii', 'Показы для данной аудитории исключены')
                        } :
                        '',
                    { elem: 'error-text' },
                    { elem: 'remove-rate' }
                ]
            }
        ];
    })
);
