block('b-adjustment-rates').elem('list-item').elemMod('type', 'device')(

    js()(function() {
        return { modelId: this.ctx.modelId };
    }),

    mix()(function() {
        var ctx = this.ctx;

        return {
            block: 'i-glue',
            js: {
                modelName: 'm-adjustment-devices-rate',
                modelId: ctx.modelId
            }
        }
    }),

    content()(function() {
        var rate = this.ctx.rate;

        return [
            {
                elem: 'cell',
                content: [
                    {
                        block: 'button',
                        mods: { arrow: 'down' },
                        mix: [{
                            block: 'b-adjustment-rates',
                            elem: 'button',
                            elemMods: { action: 'toggle-device' }
                        }],
                        js: { 'rate-id': this.ctx.modelId },
                        content: {
                            block: 'i-glue',
                            elem: 'model-field',
                            js: { name: 'deviceName', type: 'inline' },
                            content: rate.deviceName
                        }
                    }
                ]
            },
            {
                elem: 'cell',
                content: [
                    {
                        elem: 'control',
                        elemMods: { type: 'sign' },
                        width: '9em',
                        value: rate.sign
                    },
                    {
                        elem: 'control',
                        elemMods: { type: 'input' },
                        value: rate.input,
                        max: rate.max
                    },
                    {
                        elem: 'warning-text',
                        content: iget2(
                            'b-adjustment-rates',
                            'shows-for-these-devices-are-excluded',
                            'Показы для этих устройств исключены'
                        )
                    },
                    { elem: 'remove-rate' },
                    { elem: 'error-text' }
                ]
            }
        ];
    })
);
