block('b-adjustment-rates').elem('list-item').elemMod('type', 'retargeting')(

    js()(function() {
        return { modelId: this.ctx.rate.modelId };
    }),

    content()(function() {
        var rate = this.ctx.rate,
            disabled = this.ctx.disabled || ''; // при мердже с 44456-coef-rmp-mobile2 прокинуть везде disabled

        return [
            {
                elem: 'cell',
                content: [
                    {
                        block: 'button',
                        mods: { disabled: disabled },
                        mix: [{
                            block: 'b-adjustment-rates',
                            elem: 'button',
                            elemMods: {
                                action: 'toggle-chooser',
                                accessible: rate.isAccessible ? 'yes' : 'no'
                            }
                        }],
                        content: rate.name
                    },
                    rate.isAccessible ?
                        '' :
                        {
                            block: 'b-help-link',
                            mods: {
                                type: 'modal',
                                align: 'baseline'
                            },
                            width: 710,
                            stretched: true,
                            url: u.getHelpUrl('retargeting-bids-incorrect-condition')
                        }
                ]
            },
            {
                elem: 'cell',
                mix: [{
                    block: 'i-glue',
                    js: {
                        modelName: 'm-adjustment-retargeting-rate',
                        modelParentPath: this.ctx.modelParentPath,
                        modelId: rate.modelId
                    }
                }],
                content: [
                    {
                        elem: 'control',
                        elemMods: { type: 'sign' },
                        width: '9em',
                        value: rate.sign
                    },
                    {
                        elem: 'control',
                        elemMods: { type: 'input' },
                        value: rate.input,
                        max: rate.max,
                        disabled: disabled
                    },
                    {
                        elem: 'warning-text',
                        content: iget2('b-adjustment-rates', 'pokazy-dlya-dannoy-auditorii', 'Показы для данной аудитории исключены')
                    },
                    { elem: 'remove-rate' },
                    { elem: 'error-text' }
                ]
            }
        ];
    })
);
