block('b-adjustment-rates').elem('list-item').elemMod('type', 'weather')(

    js()(function() {
        return { modelId: this.ctx.modelId };
    }),

    mix()(function() {
        return {
            block: 'i-glue',
            js: {
                modelName: 'm-adjustment-weather-rate',
                modelId: this.ctx.modelId
            }
        }
    }),

    content()(function() {
        var ctx = this.ctx,
            rate = ctx.rate;

        return [
            {
                elem: 'cell',
                content: [
                    {
                        block: 'button',
                        mods: { arrow: 'down' },
                        mix: [{
                            block: 'b-adjustment-rates',
                            elem: 'button',
                            elemMods: { action: 'toggle-parameter' }
                        }],
                        js: { 'rate-id': ctx.modelId },
                        content: {
                            block: 'i-glue',
                            elem: 'model-field',
                            js: { name: 'parameter', type: 'inline' },
                            content: u['b-rates-chooser'].weather.getParameterText(rate.parameter)
                        }
                    },
                    rate.parameter === 'temp' ?
                        [
                            {
                                elem: 'from',
                                content: iget2('b-adjustment-rates', 'from', 'от')
                            },
                            {
                                block: 'input',
                                mods: { size: 's', theme: 'normal', clear: 'no' },
                                mix: [
                                    {
                                        block: 'i-glue',
                                        elem: 'model-field',
                                        js: { name: 'ge', type: 'input' }
                                    },
                                    {
                                        block: 'b-adjustment-rates',
                                        elem: 'weather-lege-input'
                                    }
                                ],
                                content: { elem: 'control' },
                                value: rate.ge
                            },
                            {
                                elem: 'to',
                                content: iget2('b-adjustment-rates', 'to', 'до')
                            },
                            {
                                block: 'input',
                                mods: { size: 's', theme: 'normal', clear: 'no' },
                                mix: [
                                    {
                                        block: 'i-glue',
                                        elem: 'model-field',
                                        js: { name: 'le', type: 'input' }
                                    },
                                    {
                                        block: 'b-adjustment-rates',
                                        elem: 'weather-lege-input'
                                    }
                                ],
                                content: { elem: 'control' },
                                value: rate.le
                            },
                            {
                                elem: 'celsius',
                                content: iget2('b-adjustment-rates', 'celsius', '°C')
                            }
                        ] :
                        {
                            block: 'button',
                            mods: { arrow: 'down' },
                            mix: [{
                                block: 'b-adjustment-rates',
                                elem: 'button',
                                elemMods: { action: 'toggle-parameter-value' }
                            }],
                            js: { 'rate-id': ctx.modelId },
                            content: {
                                block: 'i-glue',
                                elem: 'model-field',
                                js: { name: 'values', type: 'inline' },
                                content: (rate.values || [])
                                    .map(function(value) {
                                        return u['b-rates-chooser'].weather.getParameterValueText(rate.parameter, value)
                                    })
                                    .join(', ')

                            }
                        }
                ]
            },
            {
                elem: 'cell',
                content: [
                    {
                        elem: 'control',
                        elemMods: { type: 'sign' },
                        width: '9em',
                        value: rate.sign
                    },
                    {
                        elem: 'control',
                        elemMods: { type: 'input' },
                        value: rate.input,
                        max: rate.max
                    },
                    {
                        elem: 'warning-text',
                        content: iget2(
                            'b-adjustment-rates',
                            'shows-for-these-parameter-are-excluded',
                            'Показы для этих погодных условий исключены'
                        )
                    },
                    { elem: 'remove-rate' },
                    { elem: 'error-text' }
                ]
            }
        ];
    })
);
