block('b-adjustment-rates').mod('type', 'demography')(

    mix()(function() {
        return [{
            block: 'i-glue',
            js: {
                modelName: 'm-adjustment-demography-rates',
                modelId: this.ctx.modelId
            }
        }];
    }),

    content()(function() {
        return [
            { elem: 'empty' },
            {
                elem: 'list-head',
                left: [
                    iget2('b-adjustment-rates', 'pol-i-vozrast-polzovatelya', 'Пол и возраст пользователя'),
                    {
                        block: 'b-help-link',
                        mods: {
                            type: 'modal',
                            align: 'baseline'
                        },
                        stretched: true,
                        url: u.getHelpUrl('social-demographic-bids-adjustment')
                    }
                ],
                right: this.ctx.modelData.canChangeSign ?
                    [
                        {
                            elem: 'control',
                            attrs: { before: iget2('b-adjustment-rates', 'bid', 'Ставка') },
                            elemMods: {
                                type: 'sign',
                                for: 'common-sign'
                            },
                            modelId: 'common-demography' + this.ctx.modelId
                        },
                        {
                            elem: 'control',
                            elemMods: {
                                type: 'input',
                                for: 'common-input'
                            },
                            modelId: 'common-demography' + this.ctx.modelId
                        }
                    ] :
                    {
                        elem: 'control',
                        attrs: { text: iget2('b-adjustment-rates', 'uvelichit-stavku-na', 'Увеличить ставку на') },
                        modelId: 'common-demography' + this.ctx.modelId,
                        max: this.ctx.modelData.common_control && this.ctx.modelData.common_control.max,
                        elemMods: {
                            type: 'input',
                            for: 'common-input'
                        }
                    }
            },
            { elem: 'list' },
            {
                elem: 'error-text',
                elemMods: { type: 'cross' },
                mix: {
                    block: 'i-glue',
                    elem: 'model-field',
                    js: {
                        name: 'crossErrors',
                        type: 'inline-hideable'
                    }
                }
            },
            {
                elem: 'error-text',
                elemMods: { type: 'gender-age' },
                mix: {
                    block: 'i-glue',
                    elem: 'model-field',
                    js: {
                        name: 'genderAgeErrors',
                        type: 'inline'
                    }
                }
            },
            {
                elem: 'actions',
                content: [
                    {
                        elem: 'tumbler',
                        state: this.ctx.modelData.isEnabled
                    },
                    { elem: 'add-rate' }
                ]
            }
        ];
    })
);
