BEM.DOM.decl({ block: 'b-adjustment-rates', modName: 'type', modVal: 'demography' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._initModel();

            this._commonControlsNames = this.model.get('canChangeSign') ? ['input', 'sign'] : ['input'];

            this._buildRates()
                ._updateRatesStatus()
                ._bindControls()
                ._toggleRates();

            this._subMan.on(this._getAddRatesButton(), 'click', this._onAddRateClick, this);
        }
    },

    /**
     * Подписка на контролы внутри блока
     * @returns {BEM.DOM}
     * @private
     */
    _bindControls: function() {
        this._subMan.on(BEM.blocks['select'], this.elem('list'), 'change', this._selectChange, this);
        this._subMan.on(BEM.blocks['radio-button'], this.elem('list'), 'change', this._radioChange, this);

        this._bindGroupControls();

        return this;
    },

    /**
     * Привязываем события к изменениям группового контрола
     * @override;
     * @private
     */
    _bindGroupControls: function() {
        this.__base.apply(this, arguments);

        this.model.get('canChangeSign') &&
            this._subMan.on(this._getCommonControl('sign'), 'change', this._onCommonSignChange, this);
    },

    /**
     * Реакция на изменение массового sign
     * @param {Object} e
     * @private
     */
    _onCommonSignChange: function(e) {
        //@heliarian _onCommonSignChange и заполнение модели происходят одновременно.
        // Нужно убедится, что поле модели уже заполнено
        this.afterCurrentEvent(function() {
            this._onCommonControlChange('sign')
        });
    },

    /**
     * Обновляет модель исходя из состояния групповых контролов
     * Всегда апдейтим элементы парой, если они не нулевые
     *
     * @override
     * @private
     */
    _updateModelsFromCommon: function() {
        var commonModel = this._getCommonControlModel(),
            input = commonModel.get('input'),
            sign = commonModel.get('sign'),
            data = {};

        if (input || input === 0) data.input = input;
        if (sign) data.sign = sign;

        this.model.get('rates')
            .forEach(function(model) {
                model.update(data, { fromCommon: true });
            });
    },

    /**
     * Реакция на изменение модели корректировки
     * @param {Object} e
     * @override
     * @private
     */
    _onControlModelChange: function(e) {
        this._adjustRateExcludeWarning(e);

        this.__base.apply(this, arguments);
    },

    /**
     * Скрываем/показываем строку с предупреждением об отключении корректировки
     * @param {Object} e
     * @private
     */
    _adjustRateExcludeWarning: function(e) {
        var rateModel = e.target.model,
            listItem = this._getListItemById(rateModel);

        this.setMod(listItem,
            'warning',
            this._isRateExcluded(rateModel) ? 'yes' : '');

    },

    /**
     * Выполнено ли "отключить показы по данному условию"
     * @param {Object} rateModel
     * @returns {Boolean}
     */
    _isRateExcluded: function(rateModel) {
        return this.model.get('canChangeSign') &&
            rateModel.get('sign') == 'decrement' &&
            rateModel.get('input') == rateModel.get('default_multiplier');
    },

    /**
    * Урезанная версия валидации модели
    * @param {BEM.MODEL} model
    * @param {String} fieldName имя изменившегося поля (используется в переопределениях
    * @override;
    * @private
    */
    _preValidateModel: function(model, fieldName) {
        //@heliarian - это хак, но я не знаю как лучше вырезать проверку input когда меняется sign
        if (fieldName == 'sign' && model.isEmpty('input')) {
            model.trigger('validated', { valid: true });

            return { valid: true }
        }

        return model.validate();
    },

    /**
     * Получаем модель, подписываемся на события
     * @returns {BEM.DOM}
     * @private
     */
    _initModel: function() {
        this.model = BEM.MODEL.getOrCreate({
            name: 'm-adjustment-demography-rates',
            id: this.params.modelId
        });

        this.parentModel = BEM.MODEL.getOrCreate({
            name: 'm-adjustment-rates',
            id: this.params.modelId
        });

        this._subMan.on(this.parentModel, 'validated rollback', this._onSaveErrors, this);

        this._subMan.wrap(this.model)
            .on('rates', 'add', function(e, data) {
                this._addRow(this._bindRateModelEvents(data.model))
                    ._toggleAddRatesButton();
            }, this)
            .on('rates', 'remove', function(e, data) {
                BEM.DOM.destruct(this.findElem('list-item', 'rate-id', data.model.id));

                this._updateAgeGenderControls()
                    ._updateRatesStatus()
                    ._toggleAddRatesButton();
            }, this)
            .on('isEnabled', 'change', function(e, data) {
                data.rollback || this._toggleRates();
            }, this)
            .on('fix', this._clearCommonControls, this)
            .on('rollback', this._toggleRates, this);

        this.model.get('rates')
            .forEach(this._bindRateModelEvents, this);

        return this;
    },

    /**
     * Переключает состояние ставок относительно
     * флага isEnabled в модели
     * @returns {BEM}
     * @private
     * @override
     */
    _toggleRates: function() {
        this.__base.apply(this, arguments);

        this._updateAgeGenderControls()
    },

    /**
     * Строим ставки полученные из поля rates
     * @returns {BEM.DOM}
     * @private
     */
    _buildRates: function() {
        this.model.get('rates').forEach(this._addRow, this);

        return this;
    },

    /**
     * Строим ставки полученные из поля rates
     * @returns {BEM.DOM}
     * @private
     */
    _updateAgeGenderControls: function() {
        this._setIsAgeAll()
            ._setIsGenderAll()
            ._toggleGenderByAge()
            ._toggleAgeByGender();

        return this;
    },

    /**
     * Обрабатываем клик по кнопке добавления ставки
     * @private
     */
    _onAddRateClick: function() {
        var commonModel = this._getCommonControlModel();

        this._needScroll = true;

        this.model.get('rates').add({
            default_multiplier: commonModel.get('default_multiplier'),
            pct_max: commonModel.get('pct_max'),
            pct_min: commonModel.get('pct_min')
        });
    },

    /**
     * Удаление ставки
     * @param {Event} e
     * @private
     */
    _onRemoveRateClick: function(e) {
        var modelId = this.elemParams(this.closestElem(e.data.domElem, 'list-item')).modelId;

        this.model.get('rates').remove(modelId);
    },

    /**
     * Построение строки для новой ставки
     * @param {MODEL} rateModel
     * @private
     */
    _addRow: function(rateModel) {
        this.__base.apply(this, arguments);

        BEM.DOM.append(this.elem('list'), BEMHTML.apply({
            block: 'b-adjustment-rates',
            elem: 'list-item',
            canChangeSign: this.model.get('canChangeSign'),
            isAllGenderDisabled: this._isAgeAll,
            isAllAgeDisabled: this._isGenderAll,
            elemMods: {
                type: 'demography',
                'rate-id': rateModel.id,
                warning: this._isRateExcluded(rateModel) ? 'yes' : ''
            },
            modelId: rateModel.id,
            rate: rateModel.toJSON()
        }));

        this._updateAgeGenderControls()
            ._scrollTo(this._getListItemById(rateModel));

        return this;
    },

    /**
     * Обработка изменения состояния блока radio-button
     * @private
     */
    _radioChange: function() {
        this._setIsGenderAll()._toggleAgeByGender();
    },

    /**
     * Если выбран пол "Все" - выставляем флаг
     */
    _isGenderAll: null,

    /**
     * Проверяем есть ли у нас выбранный пол "Все"
     * @returns {BEM.DOM}
     * @private
     */
    _setIsGenderAll: function() {
        this._isGenderAll = this.findBlocksInside('radio-button').some(function(radio) {
            return radio.val() === 'all';
        });

        return this;
    },

    /**
     * Убираем возможность выбрать возраст "любой" если у нас есть
     * ставка где выбран пол "все"
     * @returns {BEM.DOM}
     * @private
     */
    _toggleAgeByGender: function() {
        this.findBlocksInside('select').forEach(function(select) {
            select.toggleOptionState('all', this._isGenderAll);
        }, this);

        return this;
    },

    /**
     * Обрабатываем изменения блоков select
     * @private
     */
    _selectChange: function() {
        this._setIsAgeAll()._toggleGenderByAge();
    },

    /**
     * Если выбран возраст "любой" - выставляем флаг
     */
    _isAgeAll: null,

    /**
     * Проверяем есть ли у нас выбранный возраст "любой"
     * @returns {BEM.DOM}
     * @private
     */
    _setIsAgeAll: function() {
        this._isAgeAll = this.findBlocksInside('select').some(function(select) {
            return select.val() === 'all';
        });

        return this;
    },

    /**
     * Убираем возможность выбрать пол "все" если у нас есть
     * ставка где выбран возраст "любой"
     * @returns {BEM.DOM}
     * @private
     */
    _toggleGenderByAge: function() {
        this.findBlocksInside('radio-button').forEach(function(radio) {
            var radioAll = radio.domElem.find('[value="all"]').closest(radio.buildSelector('radio'));

            radio.setMod(radioAll, 'disabled', this._isAgeAll || !this.model.get('isEnabled') ? 'yes' : '');
        }, this);

        return this;
    },

    /**
     * Получаем строку по id ставки в модели
     * @param {MODEL} rate
     * @returns {jQuery}
     * @private
     */
    _getListItemById: function(rate) {
        return this.findElem('list-item', 'rate-id', rate.id);
    },

    /**
     * Список контролов, которые необходимо будет задизейблить
     * при переключении тумблера
     */
    _controlsToDisable: ['button', 'select', 'input', 'radio-button'],

    /**
     * Ошибки которые показываются при нажатии на кнопку сохранить
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onSaveErrors: function(e, data) {
        var errors = data && data.errorFields && ~data.errorFields.indexOf('demography');

        this.setMod('gender-age-errors', errors ? 'show' : '' );
    },

    /**
     * Обработка фиксирования модели
     * @override
     * @private
     */
    _clearCommonControls: function() {
        this.model.get('canChangeSign') && this._getCommonControl('sign').val('');

        this.__base.apply(this, arguments);

        return this;
    }
});
