block('b-adjustment-rates').mod('type', 'devices')(

    mix()(function() {
        return [{
            block: 'i-glue',
            js: {
                modelName: 'm-adjustment-devices-rates',
                modelId: this.ctx.modelId
            }
        }];
    }),

    content()(function() {
        return [
            { elem: 'empty' },
            {
                elem: 'list-head',
                left: [
                    iget2('b-adjustment-rates', 'devices-retargeting', 'Тип устройства'),
                    {
                        block: 'b-help-link',
                        mods: {
                            type: 'modal',
                            align: 'baseline'
                        },
                        stretched: true,
                        url: u.getHelpUrl('device-bids-adjustment')
                    }
                ],
                right: [
                    {
                        elem: 'control',
                        attrs: { before: iget2('b-adjustment-rates', 'bid', 'Ставка') },
                        elemMods: { type: 'sign', for: 'common-sign' },
                        mix: {
                            block: 'i-glue',
                            js: {
                                modelName: 'm-adjustment-devices-rate',
                                modelId: 'common-devices' + this.ctx.modelId
                            }
                        }
                    },
                    {
                        elem: 'control',
                        elemMods: { type: 'input', for: 'common-input' },
                        mix: {
                            block: 'i-glue',
                            js: {
                                modelName: 'm-adjustment-devices-rate',
                                modelId: 'common-devices' + this.ctx.modelId
                            }
                        }
                    }
                ]
            },
            { elem: 'list' },
            {
                elem: 'error-text',
                elemMods: { type: 'cross' },
                mix: {
                    block: 'i-glue',
                    elem: 'model-field',
                    js: {
                        name: 'crossErrors',
                        type: 'inline-hideable'
                    }
                }
            },
            {
                elem: 'actions',
                content: [
                    { elem: 'add-rate' }
                ]
            }
        ];
    })
);
