block('b-adjustment-rates').mod('type', 'retargeting')(

    content()(function() {

        return [
            {
                elem: 'list-head',
                left: [
                    iget2('b-adjustment-rates', 'usloviya-podbora-auditorii', 'Условия подбора аудитории'),
                    {
                        block: 'b-help-link',
                        mods: {
                            type: 'modal',
                            align: 'baseline'
                        },
                        stretched: true,
                        url: u.getHelpUrl('retargeting-bids-adjustment')
                    }
                ],
                right: [
                    {
                        elem: 'control',
                        attrs: { before: iget2('b-adjustment-rates', 'bid', 'Ставка') },
                        elemMods: { type: 'sign', for: 'common-sign' },
                        modelId: 'common-retargeting' + this.ctx.modelId
                    },
                    {
                        elem: 'control',
                        elemMods: { type: 'input', for: 'common-input' },
                        modelId: 'common-retargeting' + this.ctx.modelId
                    }
                ]
            },
            { elem: 'empty' },
            { elem: 'list' },
            {
                elem: 'no-established',
                content: [
                    iget2('b-adjustment-rates', 'v-akkaunte-net-sozdannyh', 'В аккаунте нет созданных условий подбора аудитории.'),
                    apply('setting-link')
                ]
            },
            {
                elem: 'actions',
                content: [
                    {
                        elem: 'tumbler',
                        state: this.ctx.modelData.isEnabled
                    },
                    {
                        elem: 'add-rate'
                    },
                    apply('setting-link')
                ]
            },
            {
                block: 'spin',
                mix: [{
                    block: 'b-adjustment-rates',
                    elem: 'spin'
                }],
                mods: { theme: 'gray-32' }
            }
        ];
    }),

    mode('setting-link')(function() {
        return {
            block: 'link',
            attrs: { target: '_blank' },
            mix: [{
                block: 'b-adjustment-rates',
                elem: 'setting-link'
            }],
            url: u.getUrl('showRetargetingCond', {
                ulogin: u.consts('ulogin')
            }),
            content: iget2('b-adjustment-rates', 'nastroyka-usloviy', 'Настройка условий')
        };
    })
);
