BEM.DOM.decl({ block: 'b-adjustment-rates', modName: 'type', modVal: 'retargeting' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._commonControlsNames = ['input', 'sign'];

            this._initModel()
                ._updateRetargetingList();

            this._subMan.on(this._getAddRatesButton(), 'click', this._onAddRateClick, this);

            if (this._retargetingList.count) {
                this._updateRatesStatus();

                this._buildRates()
                    .then(function(rates) {
                        var model = rates.length && rates[rates.length - 1];

                        if (model) {
                            this._scrollTo(this._getListItemById(model));
                        }

                        this._toggleRates();
                    });

                this._bindGroupControls();

                this._subMan.on(
                    BEM.MODEL,
                    { name: 'm-retargeting-condition' },
                    'create',
                    this._retargetingConditionCreate,
                    this
                );
            } else {
                this.setMod('status', 'no-established');
            }
        }
    },

    /**
     * Привязываем события к изменениям группового контрола
     * @override;
     * @private
     */
    _bindGroupControls: function() {
        this.__base.apply(this, arguments);

        this._subMan.on(this._getCommonControl('sign'), 'change', this._onCommonSignChange, this);
    },

    /**
     * Реакция на изменение массового sign
     * @param {Object} e
     * @private
     */
    _onCommonSignChange: function(e) {
        //@heliarian _onCommonSignChange и заполнение модели происходят одновременно.
        // Нужно убедится, что поле модели уже заполнено
        this.afterCurrentEvent(function() {
            this._onCommonControlChange('sign')
        });
    },

    /**
     * Обработка создания модели условий ретаргетинга
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _retargetingConditionCreate: function(e, data) {
        this._updateRetargetingList();

        if (this._popupChooser) {
            var condition = {
                retargetingId: data.model.get('ret_cond_id'),
                name: data.model.get('condition_name_escape')
            };

            this._popupChooser.getChooser().add({
                js: { text: condition.name, condition: condition },
                mix: [{
                    block: 'b-adjustment-rates-popup-chooser',
                    elem: 'chooser-item'
                }],
                name: condition.retargetingId,
                content: condition.name
            });
        }
    },

    /**
     * Реакция на изменение модели корректировки
     * @param {Object} e
     * @override
     * @private
     */
    _onControlModelChange: function(e) {
        this._adjustRateExcludeWarning(e);

        this.__base.apply(this, arguments);
    },

    /**
     * Скрываем/показываем строку с предупреждением об отключении корректировки
     * @param {Object} e
     * @private
     */
    _adjustRateExcludeWarning: function(e) {
        var rateModel = e.target.model,
            listItem = this._getListItemById(rateModel);

        this.setMod(listItem,
            'warning',
            this._isRateExcluded(rateModel) ? 'yes' : '');

    },

    /**
     * Выполнено ли "отключить показы по данному условию"
     * @param {Object} rateModel
     * @returns {Boolean}
     */
    _isRateExcluded: function(rateModel) {
        return rateModel.get('sign') == 'decrement' &&
            rateModel.get('input') == rateModel.get('default_multiplier');
    },

    /**
     * Получаем модель, подписываемся на события
     * @returns {BEM.DOM}
     * @private
     */
    _initModel: function() {
        this.model = BEM.MODEL.getOne({
            name: 'm-adjustment-retargeting-rates',
            id: this.params.modelId
        });

        this._subMan.wrap(this.model)
            .on('rates', 'remove', function(e, data) {
                var retargetingId = data.model.get('retargetingId'),
                    condition = this._retargetingList.byId[retargetingId];

                if (condition.isAccessible) {
                    this._getPopupChooser()
                        .enable(retargetingId);
                }

                this._getPopupChooser()
                    .uncheck(retargetingId);

                this._updateRatesStatus();
            }, this)
            .on('isEnabled', 'change', function(e, data) {
                data.rollback || this._toggleRates();
            }, this)
            .on('fix', this._clearCommonControls, this)
            .on('rollback', this._rollback, this);

        this.model.get('rates')
            .forEach(this._bindRateModelEvents, this);

        return this;
    },

    _rollback: function() {
        BEM.DOM.destruct(this.elem('list'), true);

        this.model.get('rates')
            .forEach(this._bindRateModelEvents, this);

        this._buildRates()
            .then(function(rates) {
                var model = rates.length && rates[rates.length - 1];

                if (model) {
                    this._scrollTo(this._getListItemById(model));
                }

                this._toggleAddRatesButton();
                this._toggleRates();
            });
    },

    /**
     * Строим ставки полученные из поля rates
     * @returns {$.Deferred}
     * @private
     */
    _buildRates: function() {
        var rates = this.model.get('rates').map(function(model) { return model; }),
            deferred = $.Deferred(),
            chunkSize = 20,
            chunkTimeout = 20,
            _this = this;

        // DIRECT-45496 (что бы крести не отставали за кнопками и инпутами)
        this.toggleMod('disabled', '', 'yes', this.model.get('isEnabled'));

        function processChunk(chunks, counter) {
            if (counter < chunks.length) {
                _this._addRow(chunks[counter]);

                _this._timerId = setTimeout(function() {
                    processChunk(chunks, counter + 1);
                }, chunkTimeout);
            } else {
                deferred.resolveWith(_this, [rates]);
            }
        }

        this._timerId = setTimeout(function() {
            processChunk(u._.chunk(rates, chunkSize), 0);
        }, 0);

        return deferred.promise();
    },

    /**
     * Шаблонизирует строку ставки
     * @param {MODEL} rateModel
     * @returns {String}
     * @private
     */
    _buildRate: function(rateModel) {
        var retargetingId = rateModel.get('retargetingId'),
            condition = this._retargetingList.byId[retargetingId];

        if (this._popupChooser) {
            this._popupChooser
                .check(retargetingId)
                .disable(retargetingId);
        }

        return BEMHTML.apply({
            block: 'b-adjustment-rates',
            elem: 'list-item',
            elemMods: {
                type: 'retargeting',
                'retargeting-id': retargetingId,
                warning: this._isRateExcluded(rateModel) ? 'yes' : ''
            },
            disabled: this.model.get('isEnabled') ? '' : 'yes',
            rate: {
                id: retargetingId,
                modelId: rateModel.get('modelId') || rateModel.id,
                name: condition.name,
                isAccessible: condition.isAccessible,
                input: rateModel.get('input'),
                sign: rateModel.get('sign'),
                max: rateModel.get('max')
            },
            modelParentPath: this.model.path()
        });
    },

    /**
     * Построение строки/строк для новой ставки
     * @param {MODEL|Array} rateModel
     * @private
     */
    _addRow: function(rateModel) {
        this.__base.apply(this, arguments);

        var rowsToAdd = '';

        if (rateModel.length) {
            rateModel.forEach(function(model) {
                rowsToAdd += this._buildRate(model);
            }, this);
        } else if (rateModel.length === undefined) {
            rowsToAdd = this._buildRate(rateModel);
        }

        rowsToAdd && BEM.DOM.append(this.elem('list'), rowsToAdd);

        return this;
    },

    /**
     * Объект с условиями ретаргетинга
     */
    _retargetingList: null,

    /**
     * Обновление объекта условий ретаргетинга
     * @returns {BEM.DOM}
     * @private
     */
    _updateRetargetingList: function() {
        var accessibleCount = 0,
            retargetingList = BEM.MODEL.get('m-retargeting-condition').map(function(condition) {
                var isAccessible = condition.get('is_accessible');

                isAccessible && accessibleCount++;

                return {
                    retargetingId: condition.get('ret_cond_id'),
                    name: condition.get('condition_name_escape'),
                    isAccessible: isAccessible
                };
            });

        this._retargetingList = {
            all: retargetingList,
            byId: u._.indexBy(retargetingList, 'retargetingId'),
            count: retargetingList.length,
            accessibleCount: accessibleCount
        };

        return this;
    },

    /**
     * Обрабатываем клик по кнопке добавления ставки
     * @private
     */
    _onAddRateClick: function() {
        this._getPopupChooser()
            .setMod('type', 'add')
            .toggle(this.elem('add-rate'));
    },

    /**
     * Обработчик live событий
     * @param {Event} e
     * @param {String} action
     * @returns {*}
     * @private
     */
    _doAction: function(e, action) {
        switch (action) {
            case 'toggle-chooser':
                return this._toggleChooser(e);
        }
    },

    /**
     * Переключение состояния блока b-chooser
     * @param {Event} e
     * @private
     */
    _toggleChooser: function(e) {
        var button = e.block.domElem,
            row = this.closestElem(button, 'list-item');

        this._getPopupChooser()
            .setMod('type', 'editing')
            .toggle(button, this.getMod(row, 'retargeting-id'));
    },

    /**
     * Обработка добавления нового условия ретаргетинга
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onConditionsAdd: function(e, data) {
        var commonModel = this._getCommonControlModel(),
            newItemsCount = data.newItems.length;

        this._needScroll = newItemsCount < 5;

        data.newItems.forEach(function(rate, index) {
            var model = this.model.get('rates').add({
                modelId: rate.condition.retargetingId,
                retargetingId: rate.condition.retargetingId,
                default_multiplier: commonModel.get('default_multiplier'),
                pct_max: commonModel.get('pct_max'),
                pct_min: commonModel.get('pct_min')
            });

            this._addRow(this._bindRateModelEvents(model));

            if (index + 1 == newItemsCount) {
                this._scrollTo(this._getListItemById(model));
                this._toggleAddRatesButton();
            }
        }, this);
    },

    /**
     * Проверка на достижения лимита ставок и возможности их добавления
     * @returns {boolean}
     * @private
     */
    _isLimit: function() {
        var isMax = this.model.get('rates').length() === this.model.get('max_conditions'),
            canAdd = this._getPopupChooser().canAdd();

        return isMax || !canAdd;
    },

    /**
     * Обработка сохранения условия ретаргетинга
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onConditionsSave: function(e, data) {
        var condition = this._retargetingList.byId[data.newName],
            row = this.findElem('list-item', 'retargeting-id', data.prevName),
            button = this.findBlockInside(row, 'button'),
            modelId = this.elemParams(row).modelId;

        this.model
            .get('rates')
            .getById(modelId)
            .set('retargetingId', condition.retargetingId);

        if (!this._retargetingList.byId[data.prevName].isAccessible) {
            this._getPopupChooser().disable(data.prevName);
        }

        this.setMod(row, 'retargeting-id', condition.retargetingId)
            .toggleMod(button.domElem, 'accessible', 'yes', 'no', !!condition.isAccessible);

        button
            .elem('text')
            .text(condition.name);
    },

    /**
     * Обработка удаления ставки
     * @param {Event} e
     * @private
     */
    _onRemoveRateClick: function(e) {
        var listItem = this.closestElem(e.data.domElem, 'list-item'),
            modelId = this.elemParams(listItem).modelId,
            retargetingId = this.model
                .get('rates').getById(modelId)
                .get('retargetingId'),
            condition = this._retargetingList.byId[retargetingId];

        BEM.DOM.destruct(listItem);

        this.model.get('rates')
            .remove(modelId);

        if (condition.isAccessible) {
            this._toggleAddRatesButton();
        }
    },

    /**
     * Получаем блока popup с блоком b-chooser
     * @returns {BEM}
     * @private
     */
    _getPopupChooser: function() {
        if (!this._popupChooser) {
            var outsidePopup = this.findBlockOutside('popup');

            this._popupChooser = BEM.DOM.append(BEM.DOM.scope, $(BEMHTML.apply({
                block: 'b-adjustment-rates-popup-chooser',
                limit: this.model.get('max_conditions'),
                conditions: this._retargetingList,
                selected: this.model
                    .get('rates')
                    .map(function(model) {
                        return model.get('retargetingId')
                    })
            }))).bem('b-adjustment-rates-popup-chooser');

            if (outsidePopup) {
                this._popupChooser
                    .getPopup()
                    .setParent(outsidePopup)
                    .setViewport(outsidePopup.domElem);
            }

            this._subMan.wrap(this._popupChooser)
                .on('add', this._onConditionsAdd, this)
                .on('save', this._onConditionsSave, this);
        }

        return this._popupChooser;
    },

    /**
     * Обновляет модель исходя из состояния групповых контролов
     * Всегда апдейтим элементы парой, если они не нулевые
     *
     * @override
     * @private
     */
    _updateModelsFromCommon: function() {
        var commonModel = this._getCommonControlModel(),
            input = commonModel.get('input'),
            sign = commonModel.get('sign'),
            data = {};

        if (input || input === 0) data.input = input;
        if (sign) data.sign = sign;

        this.model.get('rates')
            .forEach(function(model) {
                model.update(data, { fromCommon: true });
            });
    },

    /**
     * Получаем строку по id ретаргетинга ставки в модели
     * @param {MODEL} rate
     * @returns {jQuery}
     * @private
     */
    _getListItemById: function(rate) {
        return this.findElem('list-item','retargeting-id', rate.get('retargetingId'));
    },

    /**
     * Обработка фиксирования модели
     * @override
     * @private
     */
    _clearCommonControls: function() {
        this._getCommonControl('sign').val('');

        this.__base.apply(this, arguments);

        return this;
    },

    /**
    * Урезанная версия валидации модели
    * @param {BEM.MODEL} model
    * @param {String} fieldName имя изменившегося поля (используется в переопределениях
    * @override;
    * @private
    */
    _preValidateModel: function(model, fieldName) {
        //@heliarian - это хак, но я не знаю как лучше вырезать проверку input когда меняется sign
        if (fieldName == 'sign' && model.isEmpty('input')) {
            model.trigger('validated', { valid: true });

            return { valid: true }
        }

        return model.validate();
    },

    /**
     * Список контролов, которые необходимо будет задизейблить
     * при переключении тумблера
     */
    _controlsToDisable: ['button', 'input'],

    destruct: function() {
        if (this._timerId) {
            clearTimeout(this._timerId);
            this._timerId = null;
        }

        if (this._popupChooser && this._popupChooser.domElem) {
            var outsidePopup = this.findBlockOutside('popup');

            // Руками удаляем свзяку попапов, потому что в островах, в `popup`, в методе `destruct` для каждого из `_childs`
            // выполняется `BEM.DOM.destruct()`, а потом дергается метод `delMod`
            if (outsidePopup) {
                outsidePopup.removeChild(this._popupChooser.getPopup());
            }

            BEM.DOM.destruct(this._popupChooser.domElem);
        }

        this.__base.apply(this, arguments);
    }

});
