block('b-adjustment-rates').mod('type', 'traffic-jam')(

    mix()(function() {
        return [{
            block: 'i-glue',
            js: {
                modelName: 'm-adjustment-traffic-jam-rates',
                modelId: this.ctx.modelId
            }
        }];
    }),

    content()(function() {
        return [
            { elem: 'empty' },
            {
                elem: 'list-head',
                content: [
                    {
                        elem: 'list-head-label',
                        content: [
                            iget2(
                                'b-adjustment-rates',
                                'traffic-jam-title',
                                'Корректировки по дорожной ситуации'
                            ),
                            {
                                block: 'b-help-link',
                                mods: { type: 'modal', align: 'baseline' },
                                stretched: true,
                                url: u.getHelpUrl('congestion-bids-adjustment')
                            }
                        ]
                    },
                    {
                        elem: 'list-head-line',
                        content: iget2(
                            'b-adjustment-rates',
                            'traffic-jam-desc',
                            'Корректировки работают по данным Яндекс.Карт. Для наружной рекламы учитывается дорожная ситуация перед рекламной поверхностью.'
                        )
                    },
                    {
                        elem: 'list-head-line-rate',
                        content: [
                            {
                                elem: 'cell',
                                mix: { elem: 'list-head-label' },
                                content: iget2('b-adjustment-rates', 'rate', 'Ставка')
                            },
                            {
                                elem: 'cell',
                                content: [
                                    {
                                        elem: 'control',
                                        elemMods: { type: 'sign', for: 'common-sign' },
                                        mix: {
                                            block: 'i-glue',
                                            js: {
                                                modelName: 'm-adjustment-traffic-jam-rate',
                                                modelId: 'common-traffic-jam' + this.ctx.modelId
                                            }
                                        }
                                    },
                                    {
                                        elem: 'control',
                                        elemMods: { type: 'input', for: 'common-input' },
                                        mix: {
                                            block: 'i-glue',
                                            js: {
                                                modelName: 'm-adjustment-traffic-jam-rate',
                                                modelId: 'common-traffic-jam' + this.ctx.modelId
                                            }
                                        }
                                    }
                                ]
                            }
                        ]
                    }
                ]
            },
            { elem: 'list' },
            {
                elem: 'error-text',
                elemMods: { type: 'cross' },
                mix: {
                    block: 'i-glue',
                    elem: 'model-field',
                    js: {
                        name: 'crossErrors',
                        type: 'inline-hideable'
                    }
                }
            },
            {
                elem: 'actions',
                content: [
                    { elem: 'add-rate' }
                ]
            }
        ];
    })
);
