BEM.DOM.decl({ block: 'b-adjustment-rates', modName: 'type', modVal: 'traffic-jam' }, {

    onSetMod: {

        js: function() {
            this._subMan = BEM.create('i-subscription-manager');

            this._initModel();

            this._commonControlsNames = ['input', 'sign'];

            this._buildRates()
                ._updateRatesStatus()
                ._bindControls();

            this._toggleAddRatesButton();

            this._subMan.on(this._getAddRatesButton(), 'click', this._onAddRateClick, this);
        }

    },

    _initModel: function() {
        this.model = BEM.MODEL.getOrCreate({
            name: 'm-adjustment-traffic-jam-rates',
            id: this.params.modelId
        });

        // Хак, чтобы наличие изменений в поле `choosedDevices` не влияли на результат `isChanged()` всей модели,
        // потому как у самовысчитывающегося поля изначально `isChanged() === true`
        this.model.fix();

        this.parentModel = BEM.MODEL.getOrCreate({
            name: 'm-adjustment-rates',
            id: this.params.modelId
        });

        this._subMan.wrap(this.model)
            .on('rates', 'add', function(e, data) {
                this._addRow(this._bindRateModelEvents(data.model))
                    ._toggleAddRatesButton();
            }, this)
            .on('rates', 'remove', function(e, data) {
                BEM.DOM.destruct(this.findElem('list-item', 'rate-id', data.model.id));

                this
                    ._updateRatesStatus()
                    ._toggleAddRatesButton();
            }, this);

        this.model.get('rates')
            .forEach(this._bindRateModelEvents, this);

        return this;
    },

    _bindControls: function() {
        this._bindGroupControls();
    },

    /**
     * Привязываем события к изменениям группового контрола
     * @override;
     * @private
     */
    _bindGroupControls: function() {
        this.__base.apply(this, arguments);

        this._subMan.on(this._getCommonControl('sign'), 'change', this._onCommonSignChange, this);
    },

    /**
     * Реакция на изменение массового sign
     * @param {Object} e
     * @private
     */
    _onCommonSignChange: function(e) {
        //@heliarian _onCommonSignChange и заполнение модели происходят одновременно.
        // Нужно убедится, что поле модели уже заполнено
        this.afterCurrentEvent(function() {
            this._onCommonControlChange('sign')
        });
    },

    /**
     * Строим ставки полученные из поля rates
     * @returns {BEM.DOM}
     * @private
     */
    _buildRates: function() {
        this.model.get('rates').forEach(this._addRow, this);

        return this;
    },

    /**
     * Построение строки для новой ставки
     * @param {MODEL} rateModel
     * @private
     */
    _addRow: function(rateModel) {
        this.__base.apply(this, arguments);

        BEM.DOM.append(this.elem('list'), BEMHTML.apply({
            block: 'b-adjustment-rates',
            elem: 'list-item',
            elemMods: {
                type: 'traffic-jam',
                'rate-id': rateModel.id,
                warning: this._isRateExcluded(rateModel) ? 'yes' : ''
            },
            modelId: rateModel.id,
            rate: rateModel.toJSON()
        }));

        return this;
    },

    _getGroups: function() {
        var helper = u['b-rates-chooser'].trafficJam;

        return [{
            isMultiChoice: true,
            items: helper.getValues().map(function(value) {
                return {
                    name: helper.getText(value),
                    value: value
                };
            })
        }];
    },

    _onAddRateClick: function(e) {
        var chooser = BEM.blocks['b-rates-chooser'].get({
            isMultiChoice: true,
            isMultiChoiceButton: true,
            disabledItems: this.model.get('choosedValues', 'raw'),
            groups: this._getGroups(),
            owner: e.block.domElem
        });

        if (chooser.isOpen()) {
            chooser.hide();
        } else {
            this._subManCommonChooser = BEM.create('i-subscription-manager');

            this._subManCommonChooser.wrap(chooser)
                .on('beforeClose', function() {
                    this._subManCommonChooser.dispose();
                    this._subManCommonChooser.destruct();
                    this._subManCommonChooser = null;
                }, this)
                .on('change', function(e, data) {
                    var values = data.value,
                        commonModel = this._getCommonControlModel();

                    values.forEach(function(value) {
                        this.model.get('rates').add({
                            value: value,
                            default_multiplier: commonModel.get('default_multiplier'),
                            pct_max: commonModel.get('pct_max'),
                            pct_min: commonModel.get('pct_min'),
                        });
                    }, this);
                }, this);

            chooser.show();
        }

        return this;
    },

    /**
     * Удаление ставки
     * @param {Event} e
     * @private
     */
    _onRemoveRateClick: function(e) {
        var modelId = this.elemParams(this.closestElem(e.data.domElem, 'list-item')).modelId;

        this.model.get('rates').remove(modelId);
    },

    /**
     * Получаем строку по id ретаргетинга ставки в модели
     * @param {MODEL} rate
     * @returns {jQuery}
     * @private
     */
    _getListItemById: function(rate) {
        return this.findElem('list-item', 'rate-id', rate.id);
    },

    /**
     * Обработчик live событий
     * @param {Event} e
     * @param {String} action
     * @returns {*}
     * @private
     */
    _doAction: function(e, action) {
        switch (action) {
            case 'toggle-type':
                return this._changeRateType(e);
            default:
                return this.__base.apply(this, arguments);
        }
    },

    _changeRateType: function(e) {
        var button = e.block,
            rateModel = this.model.get('rates').getById(button.params['rate-id']),
            chooser = BEM.blocks['b-rates-chooser'].get({
                disabledItems: this.model.get('choosedValues', 'raw'),
                prevValue: rateModel.get('value'),
                groups: this._getGroups(),
                owner: e.block.domElem
            });

        if (chooser.isOpen()) {
            chooser.hide();
        } else {
            this._subManChooser = BEM.create('i-subscription-manager');

            this._subManChooser.wrap(chooser)
                .on('beforeOpen', function() {
                    button.setMod('arrow', 'up');
                }, this)
                .on('beforeClose', function() {
                    button.setMod('arrow', 'down');

                    this._subManChooser.dispose();
                    this._subManChooser.destruct();
                    this._subManChooser = null;
                }, this)
                .on('change', function(e, data) {
                    rateModel.set('value', data.value);
                }, this);

            chooser.show();
        }
    },

    /**
     * Обновляет модель исходя из состояния групповых контролов
     * Всегда апдейтим элементы парой, если они не нулевые
     *
     * @override
     * @private
     */
    _updateModelsFromCommon: function() {
        var commonModel = this._getCommonControlModel(),
            input = commonModel.get('input'),
            sign = commonModel.get('sign'),
            data = {};

        if (input || input === 0) data.input = input;
        if (sign) data.sign = sign;

        this.model.get('rates')
            .forEach(function(model) {
                model.update(data, { fromCommon: true });
            });
    },

    /**
     * Реакция на изменение модели корректировки
     * @param {Object} e
     * @override
     * @private
     */
    _onControlModelChange: function(e) {
        this._adjustRateExcludeWarning(e);

        this.__base.apply(this, arguments);
    },

    /**
     * Скрываем/показываем строку с предупреждением об отключении корректировки
     * @param {Object} e
     * @private
     */
    _adjustRateExcludeWarning: function(e) {
        var rateModel = e.target.model,
            listItem = this._getListItemById(rateModel);

        this.setMod(listItem,
            'warning',
            this._isRateExcluded(rateModel) ? 'yes' : '');

    },

    /**
     * Выполнено ли "отключить показы по данному условию"
     * @param {Object} rateModel
     * @returns {Boolean}
     */
    _isRateExcluded: function(rateModel) {
        return rateModel.get('sign') === 'decrement' && rateModel.get('input') === rateModel.get('default_multiplier');
    },

    /**
    * Урезанная версия валидации модели
    * @param {BEM.MODEL} model
    * @param {String} fieldName имя изменившегося поля (используется в переопределениях
    * @override;
    * @private
    */
    _preValidateModel: function(model, fieldName) {
        //@heliarian - это хак, но я не знаю как лучше вырезать проверку input когда меняется sign
        if (fieldName == 'sign' && model.isEmpty('input')) {
            model.trigger('validated', { valid: true });

            return { valid: true }
        }

        return model.validate();
    },

    destruct: function() {
        u._.compact([this._subMan, this._subManChooser, this._subManCommonChooser]).forEach(function(subMan) {
            subMan.dispose();
            subMan.destruct();
            subMan = null;
        });

        this.__base.apply(this, arguments);
    }

});
