BEM.DOM.decl({ block: 'b-adjustment-rates', modName: 'type', modVal: 'video' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this.model = BEM.MODEL.getOne({
                name: 'm-adjustment-video-rate',
                id: this.params.modelId
            });

            this._subMan.on(this.model, 'input', 'change', this._onInputChange, this);

            this._input = this.findBlockInside('input', 'input');
            this._select = this.findBlockInside('select', 'select');
        }
    },

    /**
     * Обработчик live событий
     * @param {Event} e
     * @param {String} action
     * @returns {*}
     * @private
     */
    _doAction: function(e, action) {
        switch (action) {
            case 'operation':
                return this._operationChange(e);
        }
    },

    /**
     * Обработчик изменения селекта с выбором операции (уменьшение/увеличение ставки)
     * @private
     */
    _operationChange: function() {
        this._onInputChange();
    },

    /**
     * Переключение состояния контролов
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _toggle: function(e, data) {
        [this._input, this._select].forEach(function(control) {
            control.toggleMod('disabled', '', 'yes', data.value);
        });
    },

    /**
     * Обработчик изменения блока input
     * @private
     */
    _onInputChange: function() {
        var validation = this.model.validate();

        if (validation.errors) {
            this._showErrors(this.domElem, this._input, validation);
        } else {
            this.elem('error-text').text('');
            this._input.delMod('error');
            this.delMod('error');
        }
    }

});
