block('b-adjustment-rates').mod('type', 'weather')(

    mix()(function() {
        return [{
            block: 'i-glue',
            js: {
                modelName: 'm-adjustment-weather-rates',
                modelId: this.ctx.modelId
            }
        }];
    }),

    content()(function() {
        var modelData = this.ctx.modelData,
            setType = modelData.setType,
            common = modelData.common_control;

        return [
            { elem: 'empty' },
            {
                elem: 'list-head',
                elemMods: { 'set-type': modelData.setType },
                mix: {
                    block: 'i-glue',
                    elem: 'model-field',
                    js: {
                        block: 'b-adjustment-rates',
                        elem: 'list-head',
                        type: 'mod',
                        name: 'setType',
                        modName: 'set-type'
                    }
                },
                content: [
                    {
                        elem: 'list-head-label',
                        content: [
                            iget2(
                                'b-adjustment-rates',
                                'adjustment-weather-rates',
                                'Корректировки на погоду'
                            ),
                            {
                                block: 'b-help-link',
                                mods: {
                                    type: 'modal',
                                    align: 'baseline'
                                },
                                stretched: true,
                                url: u.getHelpUrl('weather-bids-adjustment')
                            }
                        ]
                    },
                    {
                        elem: 'list-head-line',
                        content: {
                            block: 'radio-button',
                            mods: { size: 's', theme: 'normal' },
                            mix: {
                                block: 'i-glue',
                                elem: 'model-field',
                                js: { name: 'setType', type: 'radio-button' }
                            },
                            value: setType,
                            content: [
                                {
                                    elem: 'radio',
                                    controlAttrs: { value: 'and' },
                                    content: iget2('b-adjustment-rates', 'and', 'Выполнены все условия')
                                },
                                {
                                    elem: 'radio',
                                    controlAttrs: { value: 'or' },
                                    content: iget2('b-adjustment-rates', 'or', 'Выполнено хотя бы одно')
                                }
                            ]
                        }
                    },
                    {
                        elem: 'list-head-line-rate',
                        content: [
                            {
                                elem: 'cell',
                                mix: { elem: 'list-head-label' },
                                content: iget2('b-adjustment-rates', 'common-rate', 'Общая ставка')
                            },
                            {
                                elem: 'cell',
                                content: [
                                    {
                                        elem: 'control',
                                        elemMods: { type: 'sign' },
                                        width: '9em',
                                        mix: {
                                            block: 'i-glue',
                                            js: {
                                                modelName: 'm-adjustment-base-rate',
                                                modelId: 'common-weather' + this.ctx.modelId
                                            }
                                        },
                                        value: common.sign
                                    },
                                    {
                                        elem: 'control',
                                        elemMods: { type: 'input' },
                                        mix: {
                                            block: 'i-glue',
                                            js: {
                                                modelName: 'm-adjustment-base-rate',
                                                modelId: 'common-weather' + this.ctx.modelId
                                            }
                                        },
                                        value: common.input,
                                        max: common.max
                                    },
                                    { elem: 'error-text' }
                                ]
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'list',
                elemMods: { 'set-type': modelData.setType },
                mix: {
                    block: 'i-glue',
                    elem: 'model-field',
                    js: {
                        block: 'b-adjustment-rates',
                        elem: 'list',
                        type: 'mod',
                        name: 'setType',
                        modName: 'set-type'
                    }
                }
            },
            {
                elem: 'error-text',
                elemMods: { type: 'cross' },
                mix: {
                    block: 'i-glue',
                    elem: 'model-field',
                    js: {
                        name: 'crossErrors',
                        type: 'inline-hideable'
                    }
                }
            },
            {
                elem: 'actions',
                content: [
                    { elem: 'add-rate' }
                ]
            }
        ];
    })
);
