BEM.DOM.decl({ block: 'b-adjustment-rates', modName: 'type', modVal: 'weather' }, {

    onSetMod: {

        js: function() {
            this.__base.apply(this, arguments);

            this._initModel();

            this._buildRates()
                ._updateRatesStatus()
                ._bindControls();

            this._toggleAddRatesButton();

            this._subMan.on(this._getAddRatesButton(), 'click', this._onAddRateClick, this);
        },

        'single-rate': function() {}

    },

    _initModel: function() {
        this.model = BEM.MODEL.getOrCreate({
            name: 'm-adjustment-weather-rates',
            id: this.params.modelId
        });

        // Хак, чтобы наличие изменений в поле `choosedDevices` не влияли на результат `isChanged()` всей модели,
        // потому как у самовысчитывающегося поля изначально `isChanged() === true`
        this.model.fix();

        this.parentModel = BEM.MODEL.getOrCreate({
            name: 'm-adjustment-rates',
            id: this.params.modelId
        });

        this._subMan.wrap(this.model)
            .on('rates', 'add', function(e, data) {
                this._addRow(this._bindRateModelEvents(data.model))
                    ._toggleAddRatesButton();
            }, this)
            .on('rates', 'remove', function(e, data) {
                BEM.DOM.destruct(this._getListItemById(data.model));

                this
                    ._updateRatesStatus()
                    ._toggleAddRatesButton();
            }, this);

        this.model.get('rates')
            .forEach(this._bindRateModelEvents, this);

        return this;
    },

    _clearCommonControls: function() {},

    _bindControls: function() {
        this._bindGroupControls();

        return this;
    },

    /**
     * Привязываем события к изменениям группового контрола
     * @override;
     * @private
     */
    _bindGroupControls: function() {
        this.__base.apply(this, arguments);

        this._subMan.wrap(this._getCommonControl('sign'))
            .on('change', this._onCommonSignChange, this);
    },

    /**
     * Реакция на изменение массового sign
     * @param {Object} e
     * @private
     */
    _onCommonSignChange: function(e) {
        //@heliarian _onCommonSignChange и заполнение модели происходят одновременно.
        // Нужно убедится, что поле модели уже заполнено
        this.afterCurrentEvent(function() {
            this._onCommonControlChange('sign')
        });
    },

    /**
     * Строим ставки полученные из поля rates
     * @returns {BEM.DOM}
     * @private
     */
    _buildRates: function() {
        this.model.get('rates').forEach(this._addRow, this);

        return this;
    },

    _getRateHtml: function(rateModel) {
        return BEMHTML.apply({
            block: 'b-adjustment-rates',
            elem: 'list-item',
            elemMods: {
                type: 'weather',
                'rate-id': rateModel.id,
                warning: this._isRateExcluded(rateModel) ? 'yes' : ''
            },
            modelId: rateModel.id,
            rate: rateModel.toJSON()
        });
    },

    /**
     * Построение строки для новой ставки
     * @param {MODEL} rateModel
     * @private
     */
    _addRow: function(rateModel) {
        this.__base.apply(this, arguments);

        BEM.DOM.append(this.elem('list'), this._getRateHtml(rateModel));

        return this;
    },

    _getParameterGroups: function() {
        var helper = u['b-rates-chooser'].weather;

        return [{
            isMultiChoice: true,
            isMultiChoiceButton: true,
            items: helper.getParameters().map(function(groupId) {
                return {
                    name: helper.getParameterText(groupId),
                    value: groupId
                };
            })
        }];
    },

    _getParameterValueGroups: function(parameter) {
    },

    _onAddRateClick: function(e) {
        var maxConditions = this.model.get('max_conditions'),
            chooser = BEM.blocks['b-rates-chooser'].get({
                isMultiChoice: true,
                isMultiChoiceButton: true,
                disabledItems: this.model.get('setType') === 'and' ?
                    this.model.get('usedParameters', 'raw') :
                    [],
                checkLimit: this.model.get('setType') === 'and' ?
                    undefined :
                    ({
                        max: {
                            count: maxConditions - this.model.get('rates').length(),
                            text: iget2(
                                'b-adjustment-rates',
                                'more-than-max-count',
                                'Максимальное количество корректировок {size}',
                                { size: maxConditions }
                            )
                        }
                    }),
                groups: this._getParameterGroups(),
                owner: e.block.domElem
            });

        if (chooser.isOpen()) {
            chooser.hide();
        } else {
            this._subManCommonChooser = BEM.create('i-subscription-manager');

            this._subManCommonChooser.wrap(chooser)
                .on('beforeClose', function() {
                    this._subManCommonChooser.dispose();
                    this._subManCommonChooser.destruct();
                    this._subManCommonChooser = null;
                }, this)
                .on('change', function(e, data) {
                    var value = data.value,
                        commonModel = this._getCommonControlModel();

                    value.forEach(function(parameter) {
                        var valuesEnum = u['b-rates-chooser'].weather.getParameterValues(parameter);

                        this.model.get('rates').add({
                            parameter: parameter,
                            valuesEnum: valuesEnum,
                            values: [valuesEnum[0]],
                            default_multiplier: commonModel.get('default_multiplier'),
                            pct_max: commonModel.get('pct_max'),
                            pct_min: commonModel.get('pct_min')
                        });
                    }, this);
                }, this);

            chooser.show();
        }

        return this;
    },

    /**
     * Удаление ставки
     * @param {Event} e
     * @private
     */
    _onRemoveRateClick: function(e) {
        var modelId = this.elemParams(this.closestElem(e.data.domElem, 'list-item')).modelId;

        this.model.get('rates').remove(modelId);
    },

    /**
     * Получаем строку по id ретаргетинга ставки в модели
     * @param {MODEL} rate
     * @returns {jQuery}
     * @private
     */
    _getListItemById: function(rate) {
        return this.findElem('list-item', 'rate-id', rate.id);
    },

    /**
     * Обработчик live событий
     * @param {Event} e
     * @param {String} action
     * @returns {*}
     * @private
     */
    _doAction: function(e, action) {
        switch (action) {
            case 'toggle-parameter':
                return this._changeParameter(e);
            case 'toggle-parameter-value':
                return this._changeParameterValue(e);
            default:
                return this.__base.apply(this, arguments);
        }
    },

    _changeParameter: function(e) {
        var button = e.block,
            rateModel = this.model.get('rates').getById(button.params['rate-id']),
            chooser = BEM.blocks['b-rates-chooser'].get({
                disabledItems: this.model.get('setType') === 'and' ? this.model.get('usedParameters', 'raw') : [],
                prevValue: rateModel.get('parameter'),
                groups: this._getParameterGroups(),
                owner: e.block.domElem
            });

        if (chooser.isOpen()) {
            chooser.hide();
        } else {
            this._subManChooser1 = BEM.create('i-subscription-manager');

            this._subManChooser1.wrap(chooser)
                .on('beforeOpen', function() {
                    button.setMod('arrow', 'up');
                }, this)
                .on('beforeClose', function() {
                    button.setMod('arrow', 'down');

                    this._subManChooser1.dispose();
                    this._subManChooser1.destruct();
                    this._subManChooser1 = null;
                }, this)
                .on('change', function(e, data) {
                    var parameter = data.value,
                        valuesEnum = u['b-rates-chooser'].weather.getParameterValues(parameter);

                    rateModel.update({
                        parameter: parameter,
                        valuesEnum: valuesEnum,
                        values: [valuesEnum[0]]
                    });

                    BEM.DOM.replace(this._getListItemById(rateModel), this._getRateHtml(rateModel));
                }, this);

            chooser.show();
        }
    },

    _changeParameterValue: function(e) {
        var button = e.block,
            helper = u['b-rates-chooser'].weather,
            rateModel = this.model.get('rates').getById(button.params['rate-id']),
            parameter = rateModel.get('parameter'),
            chooser = BEM.blocks['b-rates-chooser'].get({
                prevValue: rateModel.get('values'),
                isMultiChoice: true,
                groups: [{
                    isMultiChoice: true,
                    items: helper.getParameterValues(parameter).map(function(value) {
                        return {
                            name: helper.getParameterValueText(parameter, value),
                            value: value
                        };
                    })
                }],
                owner: e.block.domElem,
                checkLimit: {
                    min: {
                        count: 1,
                        text: iget2(
                            'b-adjustment-rates',
                            'less-than-min-count',
                            'Должно быть выбрано хотя бы одно значение'
                        )
                    }
                }
            });

        if (chooser.isOpen()) {
            chooser.hide();
        } else {
            this._subManChooser2 = BEM.create('i-subscription-manager');

            this._subManChooser2.wrap(chooser)
                .on('beforeOpen', function() {
                    button.setMod('arrow', 'up');
                }, this)
                .on('beforeClose', function() {
                    button.setMod('arrow', 'down');

                    this._subManChooser2.dispose();
                    this._subManChooser2.destruct();
                    this._subManChooser2 = null;
                }, this)
                .on('change', function(e, data) {
                    rateModel.set('values', data.value.map(Number));
                }, this);

            chooser.show();
        }
    },

    /**
     * Обновляет модель исходя из состояния групповых контролов
     * Всегда апдейтим элементы парой, если они не нулевые
     *
     * @override
     * @private
     */
    _updateModelsFromCommon: function() {
        // общий контро в погоде не обновляет все условия
    },

    /**
     * Реакция на изменение модели корректировки
     * @param {Object} e
     * @param {Object} data
     * @override
     * @private
     */
    _onControlModelChange: function(e, data) {
        this._adjustRateExcludeWarning(e);

        this._preValidateModel(e.target.model, data.field);

    },

    /**
     * Скрываем/показываем строку с предупреждением об отключении корректировки
     * @param {Object} e
     * @private
     */
    _adjustRateExcludeWarning: function(e) {
        var rateModel = e.target.model,
            listItem = this._getListItemById(rateModel);

        this.setMod(listItem, 'warning', this._isRateExcluded(rateModel) ? 'yes' : '');
    },

    /**
     * Выполнено ли "отключить показы по данному условию"
     * @param {Object} rateModel
     * @returns {Boolean}
     */
    _isRateExcluded: function(rateModel) {
        return rateModel.get('sign') === 'decrement' && rateModel.get('input') === rateModel.get('default_multiplier');
    },

    /**
    * Урезанная версия валидации модели
    * @param {BEM.MODEL} model
    * @param {String} fieldName имя изменившегося поля (используется в переопределениях
    * @override;
    * @private
    */
    _preValidateModel: function(model, fieldName) {
        //@heliarian - это хак, но я не знаю как лучше вырезать проверку input когда меняется sign
        if (fieldName == 'sign' && model.isEmpty('input')) {
            model.trigger('validated', { valid: true });

            return { valid: true }
        }

        return model.validate();
    },

    destruct: function() {
        u._.compact([this._subManChooser1, this._subManChooser2]).forEach(function(subMan) {
            subMan.dispose();
            subMan.destruct();
            subMan = null;
        });

        this.__base.apply(this, arguments);
    }

});
