BEM.DOM.decl('b-adjustment-rates', {

    onSetMod: {
        js: function() {
            this._subMan = BEM.create('i-subscription-manager');
        },

        'single-rate': function(modName, modVal) {
            var isSingle = modVal == 'yes';

            this._clearCommonControls();
            this._toggleCommonControlsDisabled({ isSingle: isSingle })
        }
    },

    /**
     *
     * Дисаблит/раздисабливает групповые контроллы
     * @param {Object} options
     * @param {Boolean} options.isSingle
     * @returns {BEM}
     * @private
     */
    _toggleCommonControlsDisabled: function(options) {
        var disabled = options.isSingle || !this.model.get('isEnabled');

        this._commonControlsNames.forEach(function(controlName) {
            this._getCommonControl(controlName).setMod('disabled', disabled ? 'yes' : '');
        }, this);

        return this;
    },

    /**
     * Обрабатываем подписку через live события
     * @param {Event} e
     * @param {String} elemName
     * @returns {BEM}
     * @private
     */
    _findAction: function(e, elemName) {
        var domElem = e.block.domElem,
            isAction = this.findElem(elemName).is(domElem),
            action = isAction ? this.getMod(domElem, 'action') : '';

        return this._doAction(e, action);
    },

    /**
     * Обновляем статус блока, проверяя наличие и кол-во. ставок
     * @returns {BEM}
     * @private
     */
    _updateRatesStatus: function() {
        var ratesCount = this.model.get('rates').length();

        ratesCount == 1 ?
            this.setMod('single-rate', 'yes') :
            this.delMod('single-rate');

        return ratesCount ?
            this.setMod('status', 'has-rates') :
            this.setMod('status', 'empty');
    },

    _doAction: function() { return this; },

    /**
     * Добавление новой ставки
     * @returns {BEM}
     * @private
     */
    _addRow: function() {
        this._updateRatesStatus();
        this._clearCommonControls();

        return this;
    },

    _onAddRateClick: function() { return this; },

    _onRemoveRateClick: function() { return this; },

    _onTumblerChange: function(data) {
        this.model.set('isEnabled', data.checked);
    },

    _toggleTumbler: function() {
        this._getTumbler().toggleMod('checked', 'yes', this.model.get('isEnabled'));

        return this;
    },

    _tumbler: null,

    _getTumbler: function() {
        return this._tumbler || (this._tumbler = this.findBlockInside('tumbler'));
    },

    _controlsToDisable: null,

    /**
     * Переключает состояние ставок относительно
     * флага isEnabled в моделе
     * @returns {BEM}
     * @private
     */
    _toggleRates: function() {
        var state = this.model.get('isEnabled'),
            ratesCount = this.model.get('rates').length();

        this._toggleTumbler();

        if (ratesCount) {
            //дисаблим/раздисабливаем основные контроллы
            this._controlsToDisable.forEach(function(name) {
                this.findBlocksInside('list-item', name).forEach(function(control) {
                    control.toggleMod('disabled', '', 'yes', state);
                });
                this.findBlocksInside('actions', name).forEach(function(control) {
                    control.toggleMod('disabled', '', 'yes', state);
                });
            }, this);
            //дисаблим/раздисабливаем групповые контроллы
            this._toggleCommonControlsDisabled({ isSingle: this.getMod('single-rate') == 'yes' });
        }

        this._isLimit() && this._toggleAddRatesButton();

        return this.toggleMod('disabled', '', 'yes', state);
    },

    _addRatesButton: null,

    _getAddRatesButton: function() {
        return this._addRatesButton || (this._addRatesButton = this.findBlockInside('add-rate', 'button'));
    },

    /**
     * Переключение состояния кнопки добавления ставки
     * @private
     */
    _toggleAddRatesButton: function() {
        this._getAddRatesButton().toggleMod('disabled', 'yes', '', this._isLimit());

        return this;
    },

    /**
     * Проверка на достижения лимита ставок
     * @returns {boolean}
     * @private
     */
    _isLimit: function() {
        return this.model.get('rates').length() >= this.model.get('max_conditions');
    },

    /**
     * Возвращает BEM-блок групповго контролла по его имени
     * @param {String} controlName
     * @private
     */
    _getCommonControl: function(controlName) {
        this._commonControls = this._commonControls || {};

        var listItem = this.elem('list-head');

        return this._commonControls[controlName] ||
            (this._commonControls[controlName] = this.findBlockInside(
                listItem,
                u['b-adjustment-rates'].getBlockNameByControlName(controlName)));
    },

    /**
     * Возвращает модель с данными для групповых контроллов
     * @returns {BEM.MODEL}
     * @private
     */
    _getCommonControlModel: function() {
        return (this._commonModel || (this._commonModel = this.model.get('common_control')))
    },

    /**
     * Привязываем события к изменениям группового контролла
     * @private
     */
    _bindGroupControls: function() {
        this._subMan
            .on(this._getCommonControl('input'), 'blur', this._onCommonInputChange, this)
            .on(this._getCommonControlModel(), 'validated', this._onCommonValidated, this);

        return this;
    },

    /**
     * Реакция на изменение массового инпута
     * @private
     */
    _onCommonInputChange: function() {
        //@heliarian поле модели заполняется на change, данное событие срабатывает на blur, так что поле модели уже заполнено

        return this._onCommonControlChange('input')

    },

    /**
     * Реакция на изменение группового контролла
     * @param {String} name контрол, который изменился
     * @private
     */
    _onCommonControlChange: function(name) {
        var commonModel = this._getCommonControlModel(),
            value = commonModel.get(name),
            validation = this._preValidateModel(commonModel, name, true),
            hasValue = value || value === 0;

        if (!validation.errors && hasValue) {
            this._updateModelsFromCommon();
        }

        return this;
    },

    /**
     * Обновляет модель исходя из состояния групповых контролов
     * @private
     */
    _updateModelsFromCommon: function() {
        var commonModel = this._getCommonControlModel(),
            value = commonModel.get('input');

        this.model.get('rates')
            .forEach(function(model) {
                model.set('input', value, { fromCommon: true });
            });
    },

    /**
     * Реакция на событие "групповой контролл валидирован"
     * @param {Object} e
     * @param {Object} validation
     * @returns {BEM}
     * @private
     */
    _onCommonValidated: function(e, validation) {
        var input = this._getCommonControl('input');

        if (validation.errors) {
            this._showErrors(this.elem('list-head'), input, validation);
        } else {
            this._hideErrors(this.elem('list-head'), input);
        }

        return this;
    },

    _getListItemById: function() { return this; },

    /**
     * Подписываемся на изменение поля инпут модели ставки
     * и на её валидацию
     * @param {MODEL} rateModel
     * @returns {MODEL}
     * @private
     */
    _bindRateModelEvents: function(rateModel) {
        this._subMan.wrap(rateModel)
            .on('input', 'change', this._onControlModelChange, this)
            .on('sign', 'change', this._onControlModelChange, this)
            .on('validated', this._onValidated, this);

        return rateModel;
    },

    /**
     * Обработка валидации модели ставки
     * @param {Event} e
     * @param {Object} validation
     * @private
     */
    _onValidated: function(e, validation) {
        var rateModel = e.target,
            listItem = this._getListItemById(rateModel),
            input = this.findBlockOn(this.findElem(listItem, 'input'), 'input');

        validation.errors ?
            this._showErrors(listItem, input, validation) :
            this._hideErrors(listItem, input);
    },

    /**
     * Обработка изменения поля инпут модели ставки
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onControlModelChange: function(e, data) {
        var fieldName = data.field;

        this._preValidateModel(e.target.model, fieldName);

        if (!data.fromCommon) {
            var commonModel = this._getCommonControlModel(),
                control = this._getCommonControl(fieldName);

            commonModel.set(fieldName, '');

            this._hideErrors(this.elem('list-head'), control);
        }
    },

    /**
     * Урезанная версия валидации модели
     * @param {BEM.MODEL} model
     * @param {String} fieldName имя изменившегося поля
     * @private
     */
    _preValidateModel: function(model, fieldName) {
        return model.validate();
    },

    /**
     * Показываем ошибки при валидации массового и обычных инпутов
     * @param {jQuery} listItem
     * @param {BEM} input
     * @param {Object} validation
     * @returns {BEM.DOM}
     * @private
     */
    _showErrors: function(listItem, input, validation) {
        var errorTexts = validation.errors.reduce(function(res, error) {
                res[error.rule] = error.text;

                return res;
            }, {}),
            errorText;

        if (errorTexts.integerAndPositive) {
            errorText = errorTexts.integerAndPositive;
        } else {
            errorText = $.map(errorTexts, function(err) { return err;}).join('. ');
        }

        input.setMod('error', 'yes');
        this.findElem(listItem, 'error-text').text(errorText);

        return this.setMod(listItem, 'error', 'yes');
    },

    /**
     * Скрываем элемент для показа ошибок
     * @param {jQuery} listItem
     * @param {BEM} control
     * @returns {BEM.DOM}
     * @private
     */
    _hideErrors: function(listItem, control) {
        control.delMod('error');

        return this.delMod(listItem, 'error');
    },

    /**
     * {Boolean}
     * @private
     */
    _needScroll: null,

    /**
     * Скролит до элемента
     * @param {BEM} item
     * @private
     */
    _scrollTo: function(item) {
        item.length && this._needScroll && this.elem('list').animate({
            scrollTop: item.outerHeight() * item.index(),
            duration: 50
        });

        this._needScroll = false;

        return this;
    },

    /**
     * Обработка фиксирования модели
     * @private
     */
    _clearCommonControls: function() {
        var input = this._getCommonControl('input');

        input.val('');
        this._hideErrors(this.elem('list-head'), input);
        //@heliarian изменения групповых контроллов нас не колышат при проверке измелился ли попап
        this._getCommonControlModel().fix();
    },

    destruct: function() {
        if (this._subMan) {
            this._subMan.dispose();
            this._subMan.destruct();
            this._subMan = null;
        }
    }
}, {
    live: function() {
        this
            .liveInitOnBlockInsideEvent('click', 'button', function(e) {
                this._findAction(e, 'button');
            })
            .liveInitOnBlockInsideEvent('change', 'select', function(e) {
                this._findAction(e, 'select');
            })
            .liveBindTo('remove-rate', 'click', function(e) {
                this.hasMod('disabled') || this._onRemoveRateClick(e);
            })
            .liveInitOnBlockInsideEvent('change', 'tumbler', function(e, data) {
                this._onTumblerChange(data);
            });
    }
});
